/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.d;
import java.util.ArrayList;
import java.util.List;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int BR;
    private final long KL;
    private final long Si;
    private final Session Sk;
    private final int Sv;
    private final List<DataSet> Sw;
    private final int Sx;
    private boolean Sy = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new d();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.BR = versionCode;
        this.KL = startTimeMillis;
        this.Si = endTimeMillis;
        this.Sk = session;
        this.Sv = activity;
        this.Sw = dataSets;
        this.Sx = bucketType;
        this.Sy = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(2, bucket.KL, bucket.Si, bucket.Sk, bucket.Sv, Bucket.a(bucket.Sw, uniqueDataSources, uniqueDataTypes), bucket.Sx, bucket.Sy);
    }

    private static List<DataSet> a(List<RawDataSet> list, List<DataSource> list2, List<DataType> list3) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(list.size());
        for (RawDataSet rawDataSet : list) {
            arrayList.add(new DataSet(rawDataSet, list2, list3));
        }
        return arrayList;
    }

    public long getStartTimeMillis() {
        return this.KL;
    }

    public long getEndTimeMillis() {
        return this.Si;
    }

    public Session getSession() {
        return this.Sk;
    }

    public int getActivity() {
        return this.Sv;
    }

    public List<DataSet> getDataSets() {
        return this.Sw;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.Sw) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.Sx;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Bucket && this.a((Bucket)o2);
    }

    private boolean a(Bucket bucket) {
        return this.KL == bucket.KL && this.Si == bucket.Si && this.Sv == bucket.Sv && m.equal(this.Sw, bucket.Sw) && this.Sx == bucket.Sx && this.Sy == bucket.Sy;
    }

    public boolean b(Bucket bucket) {
        return this.KL == bucket.KL && this.Si == bucket.Si && this.Sv == bucket.Sv && this.Sx == bucket.Sx;
    }

    public boolean iB() {
        if (this.Sy) {
            return true;
        }
        for (DataSet dataSet : this.Sw) {
            if (!dataSet.iB()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return m.hashCode(this.KL, this.Si, this.Sv, this.Sx);
    }

    public String toString() {
        return m.h(this).a("startTime", this.KL).a("endTime", this.Si).a("activity", this.Sv).a("dataSets", this.Sw).a("bucketType", Bucket.cz(this.Sx)).a("serverHasMoreData", this.Sy).toString();
    }

    public static String cz(int n2) {
        switch (n2) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }
}

