/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.DataTypes;
import com.google.android.gms.fitness.data.Fields;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregateDataTypes {
    public static final DataType STEP_COUNT_DELTA = DataTypes.STEP_COUNT_DELTA;
    public static final DataType ACTIVITY_SUMMARY = new DataType("com.google.activity.summary", Fields.ACTIVITY, Fields.DURATION, Fields.NUM_SEGMENTS);
    public static final DataType DISTANCE_DELTA = DataTypes.DISTANCE_DELTA;
    public static final DataType HEART_RATE_SUMMARY = new DataType("com.google.heart_rate.summary", Fields.AVERAGE, Fields.MAX, Fields.MIN);
    public static final DataType LOCATION_BOUNDING_BOX = new DataType("com.google.location.bounding_box", Fields.LOW_LATITUDE, Fields.LOW_LONGITUDE, Fields.HIGH_LATITUDE, Fields.HIGH_LONGITUDE);
    public static final DataType POWER_SUMMARY = new DataType("com.google.power.summary", Fields.AVERAGE, Fields.MAX, Fields.MIN);
    public static final DataType SPEED_SUMMARY = new DataType("com.google.speed.summary", Fields.AVERAGE, Fields.MAX, Fields.MIN);
    public static final DataType WEIGHT_SUMMARY = new DataType("com.google.weight.summary", Fields.AVERAGE, Fields.MAX, Fields.MIN);
    public static final Set<DataType> INPUT_TYPES = new HashSet<DataType>(Arrays.asList(DataTypes.STEP_COUNT_DELTA, DataTypes.DISTANCE_DELTA, DataTypes.ACTIVITY_SEGMENT, DataTypes.SPEED, DataTypes.HEART_RATE_BPM, DataTypes.WEIGHT, DataTypes.LOCATION_SAMPLE));
    public static final DataType[] Sm = new DataType[]{ACTIVITY_SUMMARY, DISTANCE_DELTA, HEART_RATE_SUMMARY, LOCATION_BOUNDING_BOX, POWER_SUMMARY, SPEED_SUMMARY, STEP_COUNT_DELTA, WEIGHT_SUMMARY};
    public static final String[] Sn = new String[]{ACTIVITY_SUMMARY.getName(), DISTANCE_DELTA.getName(), HEART_RATE_SUMMARY.getName(), LOCATION_BOUNDING_BOX.getName(), POWER_SUMMARY.getName(), SPEED_SUMMARY.getName(), STEP_COUNT_DELTA.getName(), WEIGHT_SUMMARY.getName()};
    private static final Map<DataType, List<DataType>> So = new HashMap<DataType, List<DataType>>(){
        {
            this.put(DataTypes.STEP_COUNT_DELTA, Arrays.asList(DataTypes.STEP_COUNT_DELTA));
            this.put(DataTypes.DISTANCE_DELTA, Arrays.asList(DataTypes.DISTANCE_DELTA));
            this.put(DataTypes.ACTIVITY_SEGMENT, Arrays.asList(ACTIVITY_SUMMARY));
            this.put(DataTypes.SPEED, Arrays.asList(SPEED_SUMMARY));
            this.put(DataTypes.HEART_RATE_BPM, Arrays.asList(HEART_RATE_SUMMARY));
            this.put(DataTypes.WEIGHT, Arrays.asList(WEIGHT_SUMMARY));
            this.put(DataTypes.LOCATION_SAMPLE, Arrays.asList(LOCATION_BOUNDING_BOX));
        }
    };

    private AggregateDataTypes() {
    }

    public static List<DataType> getForInput(DataType inputDataType) {
        List<DataType> list = So.get(inputDataType);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }
}

