/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.Context;
import android.content.Intent;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.FitnessIntents;
import com.google.android.gms.fitness.data.DataSource;

public class ViewDataIntentBuilder {
    private final Context mContext;
    private DataSource Sh;
    private long KL;
    private long Si;
    private String Sj;

    public ViewDataIntentBuilder(Context context) {
        this.mContext = context;
    }

    public ViewDataIntentBuilder setTimeInterval(long startTimeMillis, long endTimeMillis) {
        this.KL = startTimeMillis;
        this.Si = endTimeMillis;
        return this;
    }

    public ViewDataIntentBuilder setDataSource(DataSource dataSource) {
        this.Sh = dataSource;
        return this;
    }

    public ViewDataIntentBuilder setPreferredApplication(String packageName) {
        this.Sj = packageName;
        return this;
    }

    public Intent build() {
        n.a(this.Sh != null, "Data source must be set");
        n.a(this.KL > 0L, "Start time must be set");
        n.a(this.Si > this.KL, "End time must be set and after start time");
        Intent intent = new Intent("vnd.google.fitness.VIEW");
        intent.setType(FitnessIntents.getDataTypeMimeType(this.Sh.getDataType()));
        intent.putExtra("vnd.google.fitness.start_time", this.KL);
        intent.putExtra("vnd.google.fitness.end_time", this.Si);
        c.a(this.Sh, intent, "vnd.google.fitness.data_source");
        return this.i(intent);
    }

    private Intent i(Intent intent) {
        if (this.Sj == null) {
            return intent;
        }
        Intent intent2 = new Intent(intent).setPackage(this.Sj);
        boolean bl2 = this.mContext.getPackageManager().resolveActivity(intent2, 0) != null;
        return bl2 ? intent2 : intent;
    }
}

