/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.ac;
import com.google.android.gms.drive.internal.bb;
import com.google.android.gms.drive.internal.l;
import com.google.android.gms.drive.internal.o;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import java.util.ArrayList;
import java.util.Set;

public class w
implements DriveResource {
    protected final DriveId MO;

    protected w(DriveId driveId) {
        this.MO = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.MO;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient apiClient) {
        return apiClient.a(new d(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new GetMetadataRequest(w.this.MO), (ac)new b(this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient apiClient) {
        return apiClient.a(new o.i(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new ListParentsRequest(w.this.MO), (ac)new a(this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient apiClient, Set<DriveId> parentIds) {
        if (parentIds == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        if (parentIds.isEmpty()) {
            throw new IllegalArgumentException("ParentIds must contain at least one parent.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(parentIds);
        return apiClient.b(new p.a(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new SetResourceParentsRequest(w.this.MO, arrayList), (ac)new bb(this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return apiClient.b(new d(){

            @Override
            protected void a(q q2) throws RemoteException {
                changeSet.hS().setContext(q2.getContext());
                q2.hY().a(new UpdateMetadataRequest(w.this.MO, changeSet.hS()), (ac)new b(this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, DriveEvent.Listener<ChangeEvent> listener) {
        q q2 = apiClient.a(Drive.CU);
        return q2.a(apiClient, this.MO, 1, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, DriveEvent.Listener<ChangeEvent> listener) {
        q q2 = apiClient.a(Drive.CU);
        return q2.b(apiClient, this.MO, 1, listener);
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        q q2 = apiClient.a(Drive.CU);
        return q2.a(apiClient, this.MO, 1, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        q q2 = apiClient.a(Drive.CU);
        return q2.b(apiClient, this.MO, 1, listener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient apiClient) {
        q q2 = apiClient.a(Drive.CU);
        return q2.a(apiClient, this.MO, 1);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient apiClient) {
        q q2 = apiClient.a(Drive.CU);
        return q2.b(apiClient, this.MO, 1);
    }

    private static class a
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveApi.MetadataBufferResult> De;

        public a(BaseImplementation.b<DriveApi.MetadataBufferResult> b2) {
            this.De = b2;
        }

        @Override
        public void a(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.ik(), null);
            this.De.b(new o.h(Status.Jo, metadataBuffer, false));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.De.b(new o.h(status, null, false));
        }
    }

    private static class b
    extends com.google.android.gms.drive.internal.c {
        private final BaseImplementation.b<DriveResource.MetadataResult> De;

        public b(BaseImplementation.b<DriveResource.MetadataResult> b2) {
            this.De = b2;
        }

        @Override
        public void a(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.De.b(new c(Status.Jo, new l(onMetadataResponse.il())));
        }

        @Override
        public void o(Status status) throws RemoteException {
            this.De.b(new c(status, null));
        }
    }

    private static class c
    implements DriveResource.MetadataResult {
        private final Status CM;
        private final Metadata OV;

        public c(Status status, Metadata metadata) {
            this.CM = status;
            this.OV = metadata;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public Metadata getMetadata() {
            return this.OV;
        }
    }

    private abstract class d
    extends p<DriveResource.MetadataResult> {
        private d() {
        }

        public DriveResource.MetadataResult v(Status status) {
            return new c(status, null);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.v(status);
        }
    }
}

