/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.ac;
import com.google.android.gms.drive.internal.av;
import com.google.android.gms.drive.internal.bb;
import com.google.android.gms.drive.internal.o;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.q;
import com.google.android.gms.drive.internal.v;
import java.io.InputStream;
import java.io.OutputStream;

public class r
implements DriveContents {
    private final Contents Op;

    public r(Contents contents) {
        this.Op = n.i(contents);
    }

    @Override
    public DriveId getDriveId() {
        return this.Op.getDriveId();
    }

    @Override
    public int getMode() {
        return this.Op.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.Op.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        return this.Op.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.Op.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient apiClient) {
        if (this.Op.hK()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.Op.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.Op.hJ();
        return apiClient.a(new o.d(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new OpenContentsRequest(r.this.getDriveId(), 0x20000000, r.this.Op.getRequestId()), (ac)new av(this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet) {
        ExecutionOptions executionOptions = new ExecutionOptions.Builder().build();
        return this.a(apiClient, changeSet, executionOptions);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet, ExecutionOptions executionOptions) {
        return this.a(apiClient, changeSet, executionOptions);
    }

    @Override
    public void discard(GoogleApiClient apiClient) {
        if (this.Op.hK()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.Op.hJ();
        apiClient.b(new p.a(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new CloseContentsRequest(r.this.Op, false), (ac)new bb(this));
            }
        }).setResultCallback(new ResultCallback<Status>(){

            public void k(Status status) {
                if (!status.isSuccess()) {
                    v.q("DriveContentsImpl", "Error discarding contents");
                } else {
                    v.n("DriveContentsImpl", "Contents discarded");
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.k((Status)x0);
            }
        });
    }

    @Override
    public Contents getContents() {
        return this.Op;
    }

    private PendingResult<Status> a(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, final ExecutionOptions executionOptions) {
        if (this.Op.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.aV(executionOptions.hQ()) && !this.Op.hL()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        ExecutionOptions.a(googleApiClient, executionOptions);
        if (this.Op.hK()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet2 = metadataChangeSet != null ? metadataChangeSet : MetadataChangeSet.Nl;
        this.Op.hJ();
        return googleApiClient.b(new p.a(){

            @Override
            protected void a(q q2) throws RemoteException {
                metadataChangeSet2.hS().setContext(q2.getContext());
                q2.hY().a(new CloseContentsAndUpdateMetadataRequest(r.this.Op.getDriveId(), metadataChangeSet2.hS(), r.this.Op, executionOptions), (ac)new bb(this));
            }
        });
    }
}

