/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.d;
import com.google.android.gms.common.internal.j;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.c;
import com.google.android.gms.drive.events.d;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.ab;
import com.google.android.gms.drive.internal.ac;
import com.google.android.gms.drive.internal.ad;
import com.google.android.gms.drive.internal.bb;
import com.google.android.gms.drive.internal.o;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.y;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class q
extends com.google.android.gms.common.internal.d<ab> {
    private final String Dd;
    private final String IH;
    private final Bundle Os;
    private final boolean Ot;
    private DriveId Ou;
    private DriveId Ov;
    final GoogleApiClient.ConnectionCallbacks Ow;
    final Map<DriveId, Map<c, y>> Ox = new HashMap<DriveId, Map<c, y>>();

    public q(Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, Bundle bundle) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.Dd = n.b(clientSettings.getAccountNameOrDefault(), (Object)"Must call Api.ClientBuilder.setAccountName()");
        this.IH = clientSettings.getRealClientPackageName();
        this.Ow = connectionCallbacks;
        this.Os = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.Ot = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    throw new IllegalStateException("Drive event service " + serviceInfo.name + " must be exported in AndroidManifest.xml");
                }
                this.Ot = true;
                break;
            }
            default: {
                throw new IllegalStateException("AndroidManifest.xml can only define one service that handles the " + intent.getAction() + " action");
            }
        }
    }

    protected ab T(IBinder iBinder) {
        return ab.a.U(iBinder);
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    @Override
    protected void a(k k2, d.e e2) throws RemoteException {
        String string2 = this.getContext().getPackageName();
        n.i(e2);
        n.i(string2);
        n.i(this.gR());
        Bundle bundle = new Bundle();
        if (!string2.equals(this.IH)) {
            bundle.putString("proxy_package_name", this.IH);
        }
        bundle.putAll(this.Os);
        k2.a((j)e2, 6111000, string2, this.gR(), this.Dd, bundle);
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public ab hY() {
        return (ab)this.gS();
    }

    public DriveId hZ() {
        return this.Ou;
    }

    public DriveId ia() {
        return this.Ov;
    }

    @Override
    public void disconnect() {
        ab ab2 = (ab)this.gS();
        if (ab2 != null) {
            try {
                ab2.a(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        this.Ox.clear();
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.Ou = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.Ov = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
        }
        super.a(n2, iBinder, bundle);
    }

    public boolean ib() {
        return this.Ot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> a(GoogleApiClient googleApiClient, final DriveId driveId, final int n2, c c2) {
        n.b(d.a(n2, driveId), (Object)"id");
        n.b(c2, (Object)"listener");
        n.a(this.isConnected(), "Client must be connected");
        Map<DriveId, Map<c, y>> map = this.Ox;
        synchronized (map) {
            y y2;
            Map<c, y> map2 = this.Ox.get(driveId);
            if (map2 == null) {
                map2 = new HashMap<c, y>();
                this.Ox.put(driveId, map2);
            }
            if ((y2 = map2.get(c2)) == null) {
                y2 = new y(this.getLooper(), this.getContext(), n2, c2);
                map2.put(c2, y2);
            } else if (y2.br(n2)) {
                return new o.m(googleApiClient, Status.Jo);
            }
            y2.bq(n2);
            final y y3 = y2;
            return googleApiClient.b(new p.a(){

                @Override
                protected void a(q q2) throws RemoteException {
                    q2.hY().a(new AddEventListenerRequest(driveId, n2), (ad)y3, null, (ac)new bb(this));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> b(GoogleApiClient googleApiClient, final DriveId driveId, final int n2, c c2) {
        n.b(d.a(n2, driveId), (Object)"id");
        n.a(this.isConnected(), "Client must be connected");
        n.b(c2, (Object)"listener");
        Map<DriveId, Map<c, y>> map = this.Ox;
        synchronized (map) {
            Map<c, y> map2 = this.Ox.get(driveId);
            if (map2 == null) {
                return new o.m(googleApiClient, Status.Jo);
            }
            final y y2 = map2.remove(c2);
            if (y2 == null) {
                return new o.m(googleApiClient, Status.Jo);
            }
            if (map2.isEmpty()) {
                this.Ox.remove(driveId);
            }
            return googleApiClient.b(new p.a(){

                @Override
                protected void a(q q2) throws RemoteException {
                    q2.hY().a(new RemoveEventListenerRequest(driveId, n2), (ad)y2, null, (ac)new bb(this));
                }
            });
        }
    }

    PendingResult<Status> a(GoogleApiClient googleApiClient, final DriveId driveId, final int n2) {
        n.b(d.a(n2, driveId), (Object)"id");
        n.i("eventService");
        n.a(this.isConnected(), "Client must be connected");
        if (!this.Ot) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.b(new p.a(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new AddEventListenerRequest(driveId, n2), null, null, (ac)new bb(this));
            }
        });
    }

    PendingResult<Status> b(GoogleApiClient googleApiClient, final DriveId driveId, final int n2) {
        n.b(d.a(n2, driveId), (Object)"id");
        n.i("eventService");
        n.a(this.isConnected(), "Client must be connected");
        return googleApiClient.b(new p.a(){

            @Override
            protected void a(q q2) throws RemoteException {
                q2.hY().a(new RemoveEventListenerRequest(driveId, n2), null, null, (ac)new bb(this));
            }
        });
    }

    @Override
    protected /* synthetic */ IInterface j(IBinder iBinder) {
        return this.T(iBinder);
    }
}

