/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.b;
import com.google.android.gms.drive.internal.ae;
import com.google.android.gms.drive.internal.v;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.jy;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new b();
    final int BR;
    final DriveId MO;
    final String Dd;
    final ParcelFileDescriptor NF;
    final ParcelFileDescriptor NG;
    final MetadataBundle NH;
    final ArrayList<String> NI;
    final int Fa;
    final IBinder NJ;
    private boolean NK = false;
    private boolean NL = false;
    private boolean NM = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, ArrayList<String> trackingTags, int status, IBinder releaseCallback) {
        this.BR = versionCode;
        this.MO = driveId;
        this.Dd = accountName;
        this.NF = baseParcelFileDescriptor;
        this.NG = modifiedParcelFileDescriptor;
        this.NH = modifiedMetadataBundle;
        this.NI = trackingTags;
        this.Fa = status;
        this.NJ = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.hU();
        return this.MO;
    }

    public String getAccountName() {
        this.hU();
        return this.Dd;
    }

    public InputStream getBaseContentsInputStream() {
        this.hU();
        if (this.NF == null) {
            return null;
        }
        if (this.NK) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.NK = true;
        return new FileInputStream(this.NF.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.hU();
        if (this.NG == null) {
            return null;
        }
        if (this.NL) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.NL = true;
        return new FileInputStream(this.NG.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.hU();
        return this.NH != null ? new MetadataChangeSet(this.NH) : null;
    }

    public List<String> getTrackingTags() {
        this.hU();
        return new ArrayList<String>(this.NI);
    }

    public int getStatus() {
        this.hU();
        return this.Fa;
    }

    public void dismiss() {
        this.L(false);
    }

    public void snooze() {
        this.L(true);
    }

    private void L(boolean bl2) {
        this.hU();
        this.NM = true;
        jy.a(this.NF);
        jy.a(this.NG);
        if (this.NJ == null) {
            v.q("CompletionEvent", "No callback on " + (bl2 ? "snooze" : "dismiss"));
            return;
        }
        try {
            ae.a.X(this.NJ).L(bl2);
        }
        catch (RemoteException remoteException) {
            v.q("CompletionEvent", "RemoteException on " + (bl2 ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void hU() {
        if (this.NM) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string2 = this.NI == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.NI) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.MO, this.Fa, string2);
    }
}

