/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.q;

public final class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String Nf;
    private final boolean Ng;
    private final int Nh;

    private ExecutionOptions(String trackingTag, boolean notifyOnCompletion, int conflictStrategy) {
        this.Nf = trackingTag;
        this.Ng = notifyOnCompletion;
        this.Nh = conflictStrategy;
    }

    public String hO() {
        return this.Nf;
    }

    public boolean hP() {
        return this.Ng;
    }

    public int hQ() {
        return this.Nh;
    }

    public static boolean aV(int n2) {
        switch (n2) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean aW(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean bh(String string2) {
        return string2 != null && !string2.isEmpty() && string2.length() <= 65536;
    }

    public static void a(GoogleApiClient googleApiClient, ExecutionOptions executionOptions) {
        q q2 = googleApiClient.a(Drive.CU);
        if (executionOptions.hP() && !q2.ib()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public static final class Builder {
        private String Nf;
        private boolean Ng;
        private int Nh = 0;

        public Builder setTrackingTag(String trackingTag) {
            if (!ExecutionOptions.bh(trackingTag)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.Nf = trackingTag;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean notify) {
            this.Ng = notify;
            return this;
        }

        public Builder setConflictStrategy(int strategy) {
            if (!ExecutionOptions.aW(strategy)) {
                throw new IllegalArgumentException("Unrecognized value for conflict strategy: " + strategy);
            }
            this.Nh = strategy;
            return this;
        }

        public ExecutionOptions build() {
            if (this.Nh == 1 && !this.Ng) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
            return new ExecutionOptions(this.Nf, this.Ng, this.Nh);
        }
    }
}

