/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.e;
import com.google.android.gms.common.internal.j;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.n;
import java.util.ArrayList;

public abstract class d<T extends IInterface>
implements Api.a,
e.b {
    private final Context mContext;
    private final Looper IB;
    final Handler mHandler;
    private T Lr;
    private final ArrayList<b<?>> Ls = new ArrayList();
    private f Lt;
    private volatile int Lu = 1;
    private final String[] Ds;
    boolean Lv = false;
    private final com.google.android.gms.common.internal.e IQ;
    public static final String[] Lw = new String[]{"service_esmobile", "service_googleme"};

    protected d(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = n.i(context);
        this.IB = n.b(looper, (Object)"Looper must not be null");
        this.IQ = new com.google.android.gms.common.internal.e(context, looper, this);
        this.mHandler = new a(looper);
        this.c(stringArray);
        this.Ds = stringArray;
        this.registerConnectionCallbacks(n.i(connectionCallbacks));
        this.registerConnectionFailedListener(n.i(onConnectionFailedListener));
    }

    @Deprecated
    protected d(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new g(onConnectionFailedListener), stringArray);
    }

    protected void c(String ... stringArray) {
    }

    protected abstract String getStartServiceAction();

    protected abstract String getServiceDescriptor();

    protected abstract T j(IBinder var1);

    private void az(int n2) {
        int n3 = this.Lu;
        this.Lu = n2;
        if (n3 != n2) {
            if (n2 == 3) {
                this.onConnected();
            } else if (n3 == 3 && n2 == 1) {
                this.onDisconnected();
            }
        }
    }

    protected void onConnected() {
    }

    protected void onDisconnected() {
    }

    @Override
    public void connect() {
        this.Lv = true;
        this.az(2);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.az(1);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.Lt != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.Lr = null;
            com.google.android.gms.common.internal.f.J(this.mContext).b(this.getStartServiceAction(), this.Lt);
        }
        this.Lt = new f();
        boolean bl2 = com.google.android.gms.common.internal.f.J(this.mContext).a(this.getStartServiceAction(), this.Lt);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.getStartServiceAction()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.Lu == 3;
    }

    public boolean isConnecting() {
        return this.Lu == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.Lv = false;
        ArrayList<b<?>> arrayList = this.Ls;
        synchronized (arrayList) {
            int n2 = this.Ls.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Ls.get(i2).gV();
            }
            this.Ls.clear();
        }
        this.az(1);
        this.Lr = null;
        if (this.Lt != null) {
            com.google.android.gms.common.internal.f.J(this.mContext).b(this.getStartServiceAction(), this.Lt);
            this.Lt = null;
        }
    }

    public void aA(int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n2));
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.IB;
    }

    public final String[] gR() {
        return this.Ds;
    }

    protected final void N(IBinder iBinder) {
        try {
            k k2 = k.a.Q(iBinder);
            this.a(k2, new e(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(k var1, e var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new h(n2, iBinder, bundle)));
    }

    protected final void dK() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle fD() {
        return null;
    }

    public final T gS() {
        this.dK();
        return this.Lr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.Ls;
        synchronized (arrayList) {
            this.Ls.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean gr() {
        return this.Lv;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.IQ.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.IQ.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.IQ.registerConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.IQ.isConnectionCallbacksRegistered(new c(listener));
    }

    @Deprecated
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.IQ.unregisterConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.IQ.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.IQ.isConnectionFailedListenerRegistered(listener);
    }

    @Deprecated
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.IQ.unregisterConnectionFailedListener(listener);
    }

    public static final class e
    extends j.a {
        private d LA;

        public e(d d2) {
            this.LA = d2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            n.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.LA);
            this.LA.a(n2, iBinder, bundle);
            this.LA = null;
        }
    }

    protected final class h
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle LC;
        public final IBinder LD;

        public h(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.LD = iBinder;
            this.LC = bundle;
        }

        protected void b(Boolean bl2) {
            if (bl2 == null) {
                d.this.az(1);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.LD.getInterfaceDescriptor();
                        if (d.this.getServiceDescriptor().equals(string2)) {
                            d.this.Lr = d.this.j(this.LD);
                            if (d.this.Lr != null) {
                                d.this.az(3);
                                d.this.IQ.dM();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    com.google.android.gms.common.internal.f.J(d.this.mContext).b(d.this.getStartServiceAction(), d.this.Lt);
                    d.this.Lt = null;
                    d.this.az(1);
                    d.this.Lr = null;
                    d.this.IQ.b(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    d.this.az(1);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.LC != null) {
                        pendingIntent = (PendingIntent)this.LC.getParcelable("pendingIntent");
                    }
                    if (d.this.Lt != null) {
                        com.google.android.gms.common.internal.f.J(d.this.mContext).b(d.this.getStartServiceAction(), d.this.Lt);
                        d.this.Lt = null;
                    }
                    d.this.az(1);
                    d.this.Lr = null;
                    d.this.IQ.b(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((Boolean)object);
        }
    }

    public static final class g
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener LB;

        public g(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.LB = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.LB.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof g) {
                return this.LB.equals(((g)other).LB);
            }
            return this.LB.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks Lz;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.Lz = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.Lz.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.Lz.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.Lz.equals(((c)other).Lz);
            }
            return this.Lz.equals(other);
        }
    }

    public abstract class d<TListener>
    extends b<TListener> {
        private final DataHolder IC;

        public d(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.IC = dataHolder;
        }

        @Override
        protected final void g(TListener TListener) {
            this.a(TListener, this.IC);
        }

        protected abstract void a(TListener var1, DataHolder var2);

        @Override
        protected void gT() {
            if (this.IC != null) {
                this.IC.close();
            }
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean Ly;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.Ly = false;
        }

        protected abstract void g(TListener var1);

        protected abstract void gT();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gU() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.Ly) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.g(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.gT();
                    throw runtimeException;
                }
            } else {
                this.gT();
            }
            b2 = this;
            synchronized (b2) {
                this.Ly = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.gV();
            ArrayList arrayList = d.this.Ls;
            synchronized (arrayList) {
                d.this.Ls.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gV() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !d.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.gT();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                d.this.IQ.b(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                d.this.az(1);
                d.this.Lr = null;
                d.this.IQ.aB((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !d.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.gT();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.gU();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class f
    implements ServiceConnection {
        f() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            d.this.N(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            d.this.mHandler.sendMessage(d.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

