/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.b;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new b();
    private final int BR;
    private final Uri KJ;
    private final int lf;
    private final int lg;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.BR = versionCode;
        this.KJ = url;
        this.lf = width;
        this.lg = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    public WebImage(JSONObject json) throws IllegalArgumentException {
        this(WebImage.d(json), json.optInt("width", 0), json.optInt("height", 0));
    }

    int getVersionCode() {
        return this.BR;
    }

    private static Uri d(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.KJ;
    }

    public int getWidth() {
        return this.lf;
    }

    public int getHeight() {
        return this.lg;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.lf, this.lg, this.KJ.toString());
    }

    public JSONObject bL() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.KJ.toString());
            jSONObject.put("width", this.lf);
            jSONObject.put("height", this.lg);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return m.equal(this.KJ, webImage.KJ) && this.lf == webImage.lf && this.lg == webImage.lg;
    }

    public int hashCode() {
        return m.hashCode(this.KJ, this.lf, this.lg);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }
}

