/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.n;

public class d
extends Fragment
implements DialogInterface.OnCancelListener,
LoaderManager.LoaderCallbacks<ConnectionResult> {
    private boolean Ju;
    private int Jv = -1;
    private ConnectionResult Jw;
    private final Handler Jx = new Handler(Looper.getMainLooper());
    private final SparseArray<b> Jy = new SparseArray();

    public static d a(FragmentActivity fragmentActivity) {
        d d2;
        n.aT("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            d2 = (d)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (d2 == null || d2.isRemoving()) {
            d2 = new d();
            fragmentManager.beginTransaction().add((Fragment)d2, "GmsSupportLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return d2;
    }

    public GoogleApiClient ak(int n2) {
        a a2;
        if (this.getActivity() != null && (a2 = this.am(n2)) != null) {
            return a2.Jz;
        }
        return null;
    }

    public void a(int n2, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        n.b(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        n.a(this.Jy.indexOfKey(n2) < 0, "Already managing a GoogleApiClient with id " + n2);
        b b2 = new b(googleApiClient, onConnectionFailedListener);
        this.Jy.put(n2, (Object)b2);
        if (this.getActivity() != null) {
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void al(int n2) {
        this.getLoaderManager().destroyLoader(n2);
        this.Jy.remove(n2);
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.b(this.Jv, this.Jw);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        for (int i2 = 0; i2 < this.Jy.size(); ++i2) {
            int n2 = this.Jy.keyAt(i2);
            a a2 = this.am(n2);
            if (a2 != null) {
                b b2 = (b)this.Jy.valueAt(i2);
                if (b2.Jz != a2.Jz) {
                    this.getLoaderManager().restartLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
                    continue;
                }
            }
            this.getLoaderManager().initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.Ju = savedInstanceState.getBoolean("resolving_error", false);
            this.Jv = savedInstanceState.getInt("failed_client_id", -1);
            if (this.Jv >= 0) {
                this.Jw = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.Ju);
        if (this.Jv >= 0) {
            outState.putInt("failed_client_id", this.Jv);
            outState.putInt("failed_status", this.Jw.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.Jw.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.Ju) {
            for (int i2 = 0; i2 < this.Jy.size(); ++i2) {
                this.getLoaderManager().initLoader(this.Jy.keyAt(i2), null, (LoaderManager.LoaderCallbacks)this);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl2 = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl2 = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl2 = true;
            }
        }
        if (bl2) {
            this.gv();
        } else {
            this.b(this.Jv, this.Jw);
        }
    }

    public Loader<ConnectionResult> onCreateLoader(int id2, Bundle args) {
        return new a((Context)this.getActivity(), ((b)this.Jy.get((int)id2)).Jz);
    }

    public void a(Loader<ConnectionResult> loader, ConnectionResult connectionResult) {
        if (connectionResult.isSuccess()) {
            this.an(loader.getId());
        } else {
            this.a(loader.getId(), connectionResult);
        }
    }

    public void onLoaderReset(Loader<ConnectionResult> loader) {
        if (loader.getId() == this.Jv) {
            this.gv();
        }
    }

    a am(int n2) {
        try {
            return (a)this.getLoaderManager().getLoader(n2);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Unknown loader in SupportLifecycleFragment", classCastException);
        }
    }

    private void an(int n2) {
        if (n2 == this.Jv) {
            this.gv();
        }
    }

    private void a(int n2, ConnectionResult connectionResult) {
        if (!this.Ju) {
            this.Ju = true;
            this.Jv = n2;
            this.Jw = connectionResult;
            this.Jx.post((Runnable)new c(n2, connectionResult));
        }
    }

    private void b(int n2, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        b b2 = (b)this.Jy.get(n2);
        if (b2 != null) {
            this.al(n2);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = b2.JC;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.gv();
    }

    private void gv() {
        this.Ju = false;
        this.Jv = -1;
        this.Jw = null;
        LoaderManager loaderManager = this.getLoaderManager();
        for (int i2 = 0; i2 < this.Jy.size(); ++i2) {
            int n2 = this.Jy.keyAt(i2);
            a a2 = this.am(n2);
            if (a2 != null) {
                a2.gw();
            }
            loaderManager.initLoader(n2, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
        this.a((Loader<ConnectionResult>)x0, (ConnectionResult)x1);
    }

    static class a
    extends Loader<ConnectionResult>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        public final GoogleApiClient Jz;
        private boolean JA;
        private ConnectionResult JB;

        public a(Context context, GoogleApiClient googleApiClient) {
            super(context);
            this.Jz = googleApiClient;
        }

        public void gw() {
            if (this.JA) {
                this.JA = false;
                if (this.isStarted() && !this.isAbandoned()) {
                    this.Jz.connect();
                }
            }
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.Jz.registerConnectionCallbacks(this);
            this.Jz.registerConnectionFailedListener(this);
            if (this.JB != null) {
                this.deliverResult(this.JB);
            }
            if (!(this.Jz.isConnected() || this.Jz.isConnecting() || this.JA)) {
                this.Jz.connect();
            }
        }

        protected void onStopLoading() {
            this.Jz.disconnect();
        }

        protected void onReset() {
            this.JB = null;
            this.JA = false;
            this.Jz.unregisterConnectionCallbacks(this);
            this.Jz.unregisterConnectionFailedListener(this);
            this.Jz.disconnect();
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.JA = false;
            this.a(ConnectionResult.HE);
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.JA = true;
            this.a(result);
        }

        private void a(ConnectionResult connectionResult) {
            this.JB = connectionResult;
            if (this.isStarted() && !this.isAbandoned()) {
                this.deliverResult(connectionResult);
            }
        }
    }

    private static class b {
        public final GoogleApiClient Jz;
        public final GoogleApiClient.OnConnectionFailedListener JC;

        private b(GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.Jz = googleApiClient;
            this.JC = onConnectionFailedListener;
        }
    }

    private class c
    implements Runnable {
        private final int JD;
        private final ConnectionResult JE;

        public c(int n2, ConnectionResult connectionResult) {
            this.JD = n2;
            this.JE = connectionResult;
        }

        @Override
        public void run() {
            if (this.JE.hasResolution()) {
                try {
                    int n2 = d.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)d.this);
                    int n3 = 1 + (1 + n2 << 16);
                    this.JE.startResolutionForResult((Activity)d.this.getActivity(), n3);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    d.this.gv();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.JE.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.JE.getErrorCode(), (Activity)d.this.getActivity(), d.this, 2, d.this);
            } else {
                d.this.b(this.JD, this.JE);
            }
        }
    }
}

