/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.d;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.e;
import com.google.android.gms.common.internal.n;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class b
implements GoogleApiClient {
    private final Lock IO = new ReentrantLock();
    private final Condition IP = this.IO.newCondition();
    private final e IQ;
    private final int IR;
    private final Looper IB;
    final Queue<c<?>> IS = new LinkedList();
    private ConnectionResult IT;
    private int IU;
    private volatile int IV = 4;
    private volatile int IW;
    private boolean IX = false;
    private int IY;
    private long IZ = 5000L;
    final Handler Ja;
    private final Bundle Jb = new Bundle();
    private final Map<Api.c<?>, Api.a> Jc = new HashMap();
    private final List<String> Jd;
    private boolean Je;
    private final Set<com.google.android.gms.common.api.c<?>> Jf = Collections.newSetFromMap(new WeakHashMap());
    final Set<c<?>> Jg = Collections.newSetFromMap(new ConcurrentHashMap());
    private final a Iu = new a(){

        @Override
        public void b(c<?> c2) {
            b.this.Jg.remove(c2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks Jh = new GoogleApiClient.ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(Bundle connectionHint) {
            b.this.IO.lock();
            try {
                if (b.this.IV == 1) {
                    if (connectionHint != null) {
                        b.this.Jb.putAll(connectionHint);
                    }
                    b.this.gn();
                }
            }
            finally {
                b.this.IO.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConnectionSuspended(int cause) {
            b.this.IO.lock();
            try {
                b.this.aj(cause);
                switch (cause) {
                    case 2: {
                        b.this.connect();
                        return;
                    }
                    case 1: {
                        if (b.this.gp()) {
                            return;
                        }
                        b.this.IW = 2;
                        b.this.Ja.sendMessageDelayed(b.this.Ja.obtainMessage(1), b.this.IZ);
                        return;
                    }
                }
                return;
            }
            finally {
                b.this.IO.unlock();
            }
        }
    };
    private final e.b Ji = new e.b(){

        @Override
        public boolean gr() {
            return b.this.Je;
        }

        @Override
        public boolean isConnected() {
            return b.this.isConnected();
        }

        @Override
        public Bundle fD() {
            return null;
        }
    };

    public b(Context context, Looper looper, ClientSettings clientSettings, Map<Api<?>, Api.ApiOptions> map, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2, int n2) {
        this.IQ = new e(context, looper, this.Ji);
        this.IB = looper;
        this.Ja = new b(looper);
        this.IR = n2;
        for (GoogleApiClient.ConnectionCallbacks object : set) {
            this.IQ.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.IQ.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : map.keySet()) {
            final Api.b b2 = api.gd();
            Api.ApiOptions apiOptions = map.get(api);
            this.Jc.put(api.gf(), (Api.a)b.a(b2, apiOptions, context, looper, clientSettings, this.Jh, new GoogleApiClient.OnConnectionFailedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    b.this.IO.lock();
                    try {
                        if (b.this.IT == null || b2.getPriority() < b.this.IU) {
                            b.this.IT = result;
                            b.this.IU = b2.getPriority();
                        }
                        b.this.gn();
                    }
                    finally {
                        b.this.IO.unlock();
                    }
                }
            }));
        }
        this.Jd = Collections.unmodifiableList(clientSettings.getScopes());
    }

    private static <C extends Api.a, O> C a(Api.b<C, O> b2, Object object, Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return b2.a(context, looper, clientSettings, object, connectionCallbacks, onConnectionFailedListener);
    }

    private void gn() {
        --this.IY;
        if (this.IY == 0) {
            if (this.IT != null) {
                this.IX = false;
                this.aj(3);
                if (this.gp()) {
                    this.Ja.sendMessageDelayed(this.Ja.obtainMessage(1), this.IZ);
                } else {
                    this.IQ.b(this.IT);
                }
                this.Je = false;
            } else {
                this.IV = 2;
                this.gq();
                this.IP.signalAll();
                this.go();
                if (this.IX) {
                    this.IX = false;
                    this.aj(-1);
                } else {
                    Bundle bundle = this.Jb.isEmpty() ? null : this.Jb;
                    this.IQ.d(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.a, R extends Result, T extends BaseImplementation.a<R, A>> T a(T t2) {
        this.IO.lock();
        try {
            t2.a(new BaseImplementation.CallbackHandler(this.getLooper()));
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.IS.add(t2);
            }
            T t3 = t2;
            return t3;
        }
        finally {
            this.IO.unlock();
        }
    }

    @Override
    public <A extends Api.a, T extends BaseImplementation.a<? extends Result, A>> T b(T t2) {
        n.a(this.isConnected() || this.gp(), "GoogleApiClient is not connected yet.");
        this.go();
        try {
            this.a((c<A>)t2);
        }
        catch (DeadObjectException deadObjectException) {
            this.aj(1);
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.a> void a(c<A> c2) throws DeadObjectException {
        this.IO.lock();
        try {
            n.b(c2.gf() != null, (Object)"This task can not be executed or enqueued (it's probably a Batch or malformed)");
            this.Jg.add(c2);
            c2.a(this.Iu);
            if (this.gp()) {
                c2.m(new Status(8));
                return;
            }
            A a2 = this.a(c2.gf());
            c2.b(a2);
        }
        finally {
            this.IO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go() {
        this.IO.lock();
        try {
            n.a(this.isConnected() || this.gp(), "GoogleApiClient is not connected yet.");
            while (!this.IS.isEmpty()) {
                try {
                    this.a(this.IS.remove());
                }
                catch (DeadObjectException deadObjectException) {
                    Log.w((String)"GoogleApiClientImpl", (String)"Service died while flushing queue", (Throwable)deadObjectException);
                }
            }
        }
        finally {
            this.IO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> com.google.android.gms.common.api.c<L> c(L l2) {
        n.b(l2, (Object)"Listener must not be null");
        this.IO.lock();
        try {
            com.google.android.gms.common.api.c<L> c2 = new com.google.android.gms.common.api.c<L>(this.IB, l2);
            this.Jf.add(c2);
            com.google.android.gms.common.api.c<L> c3 = c2;
            return c3;
        }
        finally {
            this.IO.unlock();
        }
    }

    @Override
    public <C extends Api.a> C a(Api.c<C> c2) {
        Api.a a2 = this.Jc.get(c2);
        n.b(a2, (Object)"Appropriate Api was not requested.");
        return (C)a2;
    }

    @Override
    public boolean a(Scope scope) {
        return this.Jd.contains(scope.gt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.IO.lock();
        try {
            this.IX = false;
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.Je = true;
            this.IT = null;
            this.IV = 1;
            this.Jb.clear();
            this.IY = this.Jc.size();
            for (Api.a a2 : this.Jc.values()) {
                a2.connect();
            }
        }
        finally {
            this.IO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        n.a(Looper.myLooper() != Looper.getMainLooper(), "blockingConnect must not be called on the UI thread");
        this.IO.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.IP.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.IO.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.HE;
                return connectionResult;
            }
            if (this.IT != null) {
                ConnectionResult connectionResult = this.IT;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.IO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        n.a(Looper.myLooper() != Looper.getMainLooper(), "blockingConnect must not be called on the UI thread");
        this.IO.lock();
        try {
            this.connect();
            long l2 = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l2 = this.IP.awaitNanos(l2);
                    if (l2 > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.HE;
                return connectionResult;
            }
            if (this.IT != null) {
                ConnectionResult connectionResult = this.IT;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.IO.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.gq();
        this.aj(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aj(int n2) {
        this.IO.lock();
        try {
            if (this.IV != 3) {
                if (n2 == -1) {
                    if (this.isConnecting()) {
                        Iterator<Object> iterator = this.IS.iterator();
                        while (iterator.hasNext()) {
                            c object = (c)iterator.next();
                            if (object.gk() == 1) continue;
                            object.cancel();
                            iterator.remove();
                        }
                    } else {
                        this.IS.clear();
                    }
                    for (c c2 : this.Jg) {
                        c2.cancel();
                    }
                    this.Jg.clear();
                    for (com.google.android.gms.common.api.c c3 : this.Jf) {
                        c3.clear();
                    }
                    this.Jf.clear();
                    if (this.IT == null && !this.IS.isEmpty()) {
                        this.IX = true;
                        return;
                    }
                }
                boolean bl2 = this.isConnecting();
                boolean bl3 = this.isConnected();
                this.IV = 3;
                if (bl2) {
                    if (n2 == -1) {
                        this.IT = null;
                    }
                    this.IP.signalAll();
                }
                this.Je = false;
                for (Api.a a2 : this.Jc.values()) {
                    if (!a2.isConnected()) continue;
                    a2.disconnect();
                }
                this.Je = true;
                this.IV = 4;
                if (bl3) {
                    if (n2 != -1) {
                        this.IQ.aB(n2);
                    }
                    this.Je = false;
                }
            }
        }
        finally {
            this.IO.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public void stopAutoManage(FragmentActivity lifecycleActivity) {
        n.a(this.IR >= 0, "Called stopAutoManage but automatic lifecycle management is not enabled.");
        d.a(lifecycleActivity).al(this.IR);
    }

    @Override
    public boolean isConnected() {
        return this.IV == 2;
    }

    @Override
    public boolean isConnecting() {
        return this.IV == 1;
    }

    private boolean gp() {
        return this.IW != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gq() {
        this.IO.lock();
        try {
            this.IW = 0;
            this.Ja.removeMessages(1);
        }
        finally {
            this.IO.unlock();
        }
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.IQ.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.IQ.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.IQ.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.IQ.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.IQ.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.IQ.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Looper getLooper() {
        return this.IB;
    }

    class b
    extends Handler {
        b(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                b.this.IO.lock();
                try {
                    if (b.this.isConnected() || b.this.isConnecting() || !b.this.gp()) {
                        return;
                    }
                    b.this.IW--;
                    b.this.connect();
                    return;
                }
                finally {
                    b.this.IO.unlock();
                }
            }
            Log.wtf((String)"GoogleApiClientImpl", (String)"Don't know how to handle this message.");
        }
    }

    static interface c<A extends Api.a> {
        public void cancel();

        public Api.c<A> gf();

        public void b(A var1) throws DeadObjectException;

        public void m(Status var1);

        public void a(a var1);

        public int gk();
    }

    static interface a {
        public void b(c<?> var1);
    }
}

