/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.b;
import com.google.android.gms.common.internal.i;
import com.google.android.gms.common.internal.n;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BaseImplementation {
    static void a(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"GoogleApi", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public static final int CALLBACK_ON_COMPLETE = 1;
        public static final int CALLBACK_ON_TIMEOUT = 2;

        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void sendTimeoutResultCallback(AbstractPendingResult<R> pendingResult, long millis) {
            this.sendMessageDelayed(this.obtainMessage(2, pendingResult), millis);
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.gj();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                BaseImplementation.a(result);
                throw runtimeException;
            }
        }
    }

    public static abstract class AbstractPendingResult<R extends Result>
    implements b<R>,
    PendingResult<R> {
        private final Object Im = new Object();
        protected CallbackHandler<R> mHandler;
        private final CountDownLatch mg = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> In = new ArrayList();
        private ResultCallback<R> Io;
        private volatile R Ip;
        private volatile boolean Iq;
        private boolean Ir;
        private boolean Is;
        private i It;

        AbstractPendingResult() {
        }

        public AbstractPendingResult(Looper looper) {
            this.mHandler = new CallbackHandler(looper);
        }

        public AbstractPendingResult(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }

        protected abstract R c(Status var1);

        public final boolean isReady() {
            return this.mg.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R gg() {
            Object object = this.Im;
            synchronized (object) {
                n.a(!this.Iq, "Result has already been consumed.");
                n.a(this.isReady(), "Result is not ready.");
                R r2 = this.Ip;
                this.gh();
                return r2;
            }
        }

        @Override
        public final R await() {
            n.a(Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
            n.a(!this.Iq, "Result has already been consumed");
            try {
                this.mg.await();
            }
            catch (InterruptedException interruptedException) {
                this.gi();
            }
            n.a(this.isReady(), "Result is not ready.");
            return this.gg();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            n.a(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread when time is greater than zero.");
            n.a(!this.Iq, "Result has already been consumed.");
            try {
                boolean bl2 = this.mg.await(time, units);
                if (!bl2) {
                    this.gj();
                }
            }
            catch (InterruptedException interruptedException) {
                this.gi();
            }
            n.a(this.isReady(), "Result is not ready.");
            return this.gg();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            n.a(!this.Iq, "Result has already been consumed.");
            Object object = this.Im;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.gg());
                } else {
                    this.Io = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            n.a(!this.Iq, "Result has already been consumed.");
            n.a(this.mHandler != null, "CallbackHandler has not been set before calling setResultCallback.");
            Object object = this.Im;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.gg());
                } else {
                    this.Io = callback;
                    this.mHandler.sendTimeoutResultCallback(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            n.a(!this.Iq, "Result has already been consumed.");
            Object object = this.Im;
            synchronized (object) {
                if (this.isReady()) {
                    a2.n(this.Ip.getStatus());
                } else {
                    this.In.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void a(i i2) {
            Object object = this.Im;
            synchronized (object) {
                this.It = i2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.Im;
            synchronized (object) {
                if (this.Ir || this.Iq) {
                    return;
                }
                if (this.It != null) {
                    try {
                        this.It.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                BaseImplementation.a(this.Ip);
                this.Io = null;
                this.Ir = true;
                this.c(this.c(Status.Js));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.Im;
            synchronized (object) {
                return this.Ir;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void b(R r2) {
            Object object = this.Im;
            synchronized (object) {
                if (this.Is || this.Ir) {
                    BaseImplementation.a(r2);
                    return;
                }
                n.a(!this.isReady(), "Results have already been set");
                n.a(!this.Iq, "Result has already been consumed");
                this.c(r2);
            }
        }

        protected void gh() {
            this.Iq = true;
            this.Ip = null;
            this.Io = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gi() {
            Object object = this.Im;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.Jp));
                    this.Is = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gj() {
            Object object = this.Im;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.Jr));
                    this.Is = true;
                }
            }
        }

        private void c(R r2) {
            this.Ip = r2;
            this.It = null;
            this.mg.countDown();
            Status status = this.Ip.getStatus();
            if (this.Io != null) {
                this.mHandler.removeTimeoutMessages();
                if (!this.Ir) {
                    this.mHandler.sendResultCallback(this.Io, this.gg());
                }
            }
            for (PendingResult.a a2 : this.In) {
                a2.n(status);
            }
            this.In.clear();
        }

        protected void a(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }
    }

    public static abstract class a<R extends Result, A extends Api.a>
    extends AbstractPendingResult<R>
    implements b.c<A> {
        private final Api.c<A> Ik;
        private b.a Iu;

        protected a(Api.c<A> c2) {
            this.Ik = n.i(c2);
        }

        @Override
        public final Api.c<A> gf() {
            return this.Ik;
        }

        @Override
        public final void b(A a2) throws DeadObjectException {
            if (this.mHandler == null) {
                this.a((A)((Object)new CallbackHandler(a2.getLooper())));
            }
            try {
                this.a(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void m(Status status) {
            n.b(!status.isSuccess(), (Object)"Failed result must not be success");
            this.b((A)this.c(status));
        }

        @Override
        public void a(b.a a2) {
            this.Iu = a2;
        }

        @Override
        public int gk() {
            return 0;
        }

        protected abstract void a(A var1) throws RemoteException;

        @Override
        protected void gh() {
            super.gh();
            if (this.Iu != null) {
                this.Iu.b(this);
                this.Iu = null;
            }
        }

        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.m(status);
        }
    }

    public static interface b<R> {
        public void b(R var1);
    }
}

