/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.internal.ik;
import com.google.android.gms.internal.jz;
import com.google.android.gms.internal.kc;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float Gd;
    private int Ge;
    private int xm;
    private int Gf;
    private int Gg;
    private int Gh;
    private int Gi;
    private int Gj;
    private String Gk;
    private int Gl;
    private int Gm;
    private JSONObject Fl;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.Gd = fontScale;
    }

    public float getFontScale() {
        return this.Gd;
    }

    public void setForegroundColor(int foregroundColor) {
        this.Ge = foregroundColor;
    }

    public int getForegroundColor() {
        return this.Ge;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.xm = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.xm;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.Gf = edgeType;
    }

    public int getEdgeType() {
        return this.Gf;
    }

    public void setEdgeColor(int edgeColor) {
        this.Gg = edgeColor;
    }

    public int getEdgeColor() {
        return this.Gg;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.Gh = windowType;
    }

    public int getWindowType() {
        return this.Gh;
    }

    public void setWindowColor(int windowColor) {
        this.Gi = windowColor;
    }

    public int getWindowColor() {
        return this.Gi;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.Gj = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.Gj;
    }

    public void setFontFamily(String fontFamily) {
        this.Gk = fontFamily;
    }

    public String getFontFamily() {
        return this.Gk;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.Gl = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.Gl;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.Gm = fontStyle;
    }

    public int getFontStyle() {
        return this.Gm;
    }

    public void setCustomData(JSONObject customData) {
        this.Fl = customData;
    }

    public JSONObject getCustomData() {
        return this.Fl;
    }

    private void clear() {
        this.Gd = 1.0f;
        this.Ge = 0;
        this.xm = 0;
        this.Gf = -1;
        this.Gg = 0;
        this.Gh = -1;
        this.Gi = 0;
        this.Gj = 0;
        this.Gk = null;
        this.Gl = -1;
        this.Gm = -1;
        this.Fl = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!kc.hH()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl2 = typeface.isBold();
            boolean bl3 = typeface.isItalic();
            if (bl2 && bl3) {
                textTrackStyle.setFontStyle(3);
            } else if (bl2) {
                textTrackStyle.setFontStyle(1);
            } else if (bl3) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void c(JSONObject jSONObject) throws JSONException {
        String string;
        this.clear();
        this.Gd = (float)jSONObject.optDouble("fontScale", 1.0);
        this.Ge = this.aC(jSONObject.optString("foregroundColor"));
        this.xm = this.aC(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string = jSONObject.getString("edgeType");
            if ("NONE".equals(string)) {
                this.Gf = 0;
            } else if ("OUTLINE".equals(string)) {
                this.Gf = 1;
            } else if ("DROP_SHADOW".equals(string)) {
                this.Gf = 2;
            } else if ("RAISED".equals(string)) {
                this.Gf = 3;
            } else if ("DEPRESSED".equals(string)) {
                this.Gf = 4;
            }
        }
        this.Gg = this.aC(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string = jSONObject.getString("windowType");
            if ("NONE".equals(string)) {
                this.Gh = 0;
            } else if ("NORMAL".equals(string)) {
                this.Gh = 1;
            } else if ("ROUNDED_CORNERS".equals(string)) {
                this.Gh = 2;
            }
        }
        this.Gi = this.aC(jSONObject.optString("windowColor"));
        if (this.Gh == 2) {
            this.Gj = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.Gk = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string)) {
                this.Gl = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string)) {
                this.Gl = 1;
            } else if ("SERIF".equals(string)) {
                this.Gl = 2;
            } else if ("MONOSPACED_SERIF".equals(string)) {
                this.Gl = 3;
            } else if ("CASUAL".equals(string)) {
                this.Gl = 4;
            } else if ("CURSIVE".equals(string)) {
                this.Gl = 5;
            } else if ("SMALL_CAPITALS".equals(string)) {
                this.Gl = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string)) {
                this.Gm = 0;
            } else if ("BOLD".equals(string)) {
                this.Gm = 1;
            } else if ("ITALIC".equals(string)) {
                this.Gm = 2;
            } else if ("BOLD_ITALIC".equals(string)) {
                this.Gm = 3;
            }
        }
        this.Fl = jSONObject.optJSONObject("customData");
    }

    public JSONObject bL() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.Gd);
            if (this.Ge != 0) {
                jSONObject.put("foregroundColor", (Object)this.t(this.Ge));
            }
            if (this.xm != 0) {
                jSONObject.put("backgroundColor", (Object)this.t(this.xm));
            }
            switch (this.Gf) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.Gg != 0) {
                jSONObject.put("edgeColor", (Object)this.t(this.Gg));
            }
            switch (this.Gh) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.Gi != 0) {
                jSONObject.put("windowColor", (Object)this.t(this.Gi));
            }
            if (this.Gh == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.Gj);
            }
            if (this.Gk != null) {
                jSONObject.put("fontFamily", (Object)this.Gk);
            }
            switch (this.Gl) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.Gm) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.Fl != null) {
                jSONObject.put("customData", (Object)this.Fl);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String t(int n2) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n2), Color.green((int)n2), Color.blue((int)n2), Color.alpha((int)n2));
    }

    private int aC(String string) {
        if (string != null && string.length() == 9 && string.charAt(0) == '#') {
            try {
                int n2 = Integer.parseInt(string.substring(1, 3), 16);
                int n3 = Integer.parseInt(string.substring(3, 5), 16);
                int n4 = Integer.parseInt(string.substring(5, 7), 16);
                int n5 = Integer.parseInt(string.substring(7, 9), 16);
                return Color.argb((int)n5, (int)n2, (int)n3, (int)n4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.Fl == null != (textTrackStyle.Fl == null)) {
            return false;
        }
        if (this.Fl != null && textTrackStyle.Fl != null && !jz.d(this.Fl, textTrackStyle.Fl)) {
            return false;
        }
        return this.Gd == textTrackStyle.Gd && this.Ge == textTrackStyle.Ge && this.xm == textTrackStyle.xm && this.Gf == textTrackStyle.Gf && this.Gg == textTrackStyle.Gg && this.Gh == textTrackStyle.Gh && this.Gj == textTrackStyle.Gj && ik.a(this.Gk, textTrackStyle.Gk) && this.Gl == textTrackStyle.Gl && this.Gm == textTrackStyle.Gm;
    }

    public int hashCode() {
        return m.hashCode(Float.valueOf(this.Gd), this.Ge, this.xm, this.Gf, this.Gg, this.Gh, this.Gi, this.Gj, this.Gk, this.Gl, this.Gm, this.Fl);
    }
}

