/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.internal.ik;
import com.google.android.gms.internal.jz;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long Dj;
    private int FD;
    private String Fe;
    private String Fg;
    private String mName;
    private String Fc;
    private int FE;
    private JSONObject Fl;

    MediaTrack(JSONObject json) throws JSONException {
        this.c(json);
    }

    MediaTrack(long id2, int type) throws IllegalArgumentException {
        this.clear();
        this.Dj = id2;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.FD = type;
    }

    public long getId() {
        return this.Dj;
    }

    public int getType() {
        return this.FD;
    }

    public String getContentId() {
        return this.Fe;
    }

    public void setContentId(String contentId) {
        this.Fe = contentId;
    }

    public String getContentType() {
        return this.Fg;
    }

    public void setContentType(String contentType) {
        this.Fg = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.Fc;
    }

    void setLanguage(String language) {
        this.Fc = language;
    }

    public int getSubtype() {
        return this.FE;
    }

    void aa(int n2) throws IllegalArgumentException {
        if (n2 <= -1 || n2 > 5) {
            throw new IllegalArgumentException("invalid subtype " + n2);
        }
        if (n2 != 0 && this.FD != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.FE = n2;
    }

    public JSONObject getCustomData() {
        return this.Fl;
    }

    void setCustomData(JSONObject customData) {
        this.Fl = customData;
    }

    private void clear() {
        this.Dj = 0L;
        this.FD = 0;
        this.Fe = null;
        this.mName = null;
        this.Fc = null;
        this.FE = -1;
        this.Fl = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void c(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.Dj = jSONObject.getLong("trackId");
        String string = jSONObject.getString("type");
        if ("TEXT".equals(string)) {
            this.FD = 1;
        } else if ("AUDIO".equals(string)) {
            this.FD = 2;
        } else {
            if (!"VIDEO".equals(string)) throw new JSONException("invalid type: " + string);
            this.FD = 3;
        }
        this.Fe = jSONObject.optString("trackContentId", null);
        this.Fg = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.Fc = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string)) {
                this.FE = 1;
            } else if ("CAPTIONS".equals(string)) {
                this.FE = 2;
            } else if ("DESCRIPTIONS".equals(string)) {
                this.FE = 3;
            } else if ("CHAPTERS".equals(string)) {
                this.FE = 4;
            } else {
                if (!"METADATA".equals(string)) throw new JSONException("invalid subtype: " + string);
                this.FE = 5;
            }
        } else {
            this.FE = 0;
        }
        this.Fl = jSONObject.optJSONObject("customData");
    }

    public JSONObject bL() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.Dj);
            switch (this.FD) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.Fe != null) {
                jSONObject.put("trackContentId", (Object)this.Fe);
            }
            if (this.Fg != null) {
                jSONObject.put("trackContentType", (Object)this.Fg);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.Fc)) {
                jSONObject.put("language", (Object)this.Fc);
            }
            switch (this.FE) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.Fl != null) {
                jSONObject.put("customData", (Object)this.Fl);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.Fl == null != (mediaTrack.Fl == null)) {
            return false;
        }
        if (this.Fl != null && mediaTrack.Fl != null && !jz.d(this.Fl, mediaTrack.Fl)) {
            return false;
        }
        return this.Dj == mediaTrack.Dj && this.FD == mediaTrack.FD && ik.a(this.Fe, mediaTrack.Fe) && ik.a(this.Fg, mediaTrack.Fg) && ik.a(this.mName, mediaTrack.mName) && ik.a(this.Fc, mediaTrack.Fc) && this.FE == mediaTrack.FE;
    }

    public int hashCode() {
        return m.hashCode(this.Dj, this.FD, this.Fe, this.Fg, this.mName, this.Fc, this.FE, this.Fl);
    }

    public static class Builder {
        private final MediaTrack FF;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.FF = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.FF.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.FF.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.FF.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.FF.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.FF.setLanguage(ik.b(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.FF.aa(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.FF.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.FF;
        }
    }
}

