/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api;

import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.auth.api.GoogleAuthApiRequestCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleAuthApiRequest
implements SafeParcelable {
    public static final int HTTP_METHOD_GET = 0;
    public static final int HTTP_METHOD_POST = 1;
    public static final int HTTP_METHOD_PUT = 2;
    public static final int HTTP_METHOD_DELETE = 3;
    public static final int HTTP_METHOD_HEAD = 4;
    public static final int HTTP_METHOD_OPTIONS = 5;
    public static final int HTTP_METHOD_TRACE = 6;
    public static final int HTTP_METHOD_PATCH = 7;
    public static final GoogleAuthApiRequestCreator CREATOR = new GoogleAuthApiRequestCreator();
    public static final int VERSION_CODE = 1;
    public static final String DEFAULT_SCOPE_PREFIX = "oauth2:";
    final int versionCode;
    String name;
    String version;
    String Dt;
    String yR;
    Bundle Du;
    String Dv;
    List<String> Dw;
    String Dx;
    int Dy;
    Bundle Dz;
    byte[] DA;
    long DB;

    public GoogleAuthApiRequest(String name, String version, String apiId) {
        this.versionCode = 1;
        this.name = name;
        this.ay(version);
        this.Dt = apiId;
        this.Du = new Bundle();
        this.Dw = new ArrayList<String>();
        this.Dx = DEFAULT_SCOPE_PREFIX;
        this.Dz = new Bundle();
        this.DA = new byte[0];
    }

    public GoogleAuthApiRequest(String name, String version, String path, int httpMethod) {
        this.versionCode = 1;
        this.name = name;
        this.ay(version);
        this.setPath(path);
        this.T(httpMethod);
        this.Du = new Bundle();
        this.Dw = new ArrayList<String>();
        this.Dx = DEFAULT_SCOPE_PREFIX;
        this.Dz = new Bundle();
        this.DA = new byte[0];
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    private void ay(String string2) {
        if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
            string2 = "v" + string2;
        }
        this.version = string2;
    }

    public String getApiId() {
        return this.Dt;
    }

    public String getPath() {
        return this.yR;
    }

    private void setPath(String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        this.yR = path;
    }

    public String getAccountName() {
        return this.Dv;
    }

    public void setAccountName(String accountName) {
        this.Dv = accountName;
    }

    public String getScope() {
        if (this.Dw.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.Dw.size(); ++i2) {
            stringBuffer.append(this.Dw.get(i2));
            if (i2 == this.Dw.size() - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String getFullScope() {
        String string2 = this.getScope();
        if (string2 == null) {
            return null;
        }
        return this.Dx + string2;
    }

    public void addScope(String scope) {
        this.Dw.add(scope);
    }

    public Bundle getParameters() {
        return this.Du;
    }

    public Map<String, List<String>> getParametersAsMap() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string2 : this.Du.keySet()) {
            hashMap.put(string2, this.Du.getStringArrayList(string2));
        }
        return hashMap;
    }

    public void addParameter(String key, String value) {
        if (!this.Du.containsKey(key)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(value);
            this.Du.putStringArrayList(key, arrayList);
        } else {
            this.Du.getStringArrayList(key).add(value);
        }
    }

    public int getHttpMethod() {
        return this.Dy;
    }

    private void T(int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid HTTP method.");
        }
        this.Dy = n2;
    }

    public void putHeader(String key, String value) {
        this.Dz.putString(key, value);
    }

    public String getHeader(String key) {
        return this.Dz.getString(key);
    }

    public Bundle getHeaders() {
        return this.Dz;
    }

    public Map<String, String> getHeadersAsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : this.Dz.keySet()) {
            hashMap.put(string2, this.Dz.getString(string2));
        }
        return hashMap;
    }

    public byte[] getHttpBody() {
        return this.DA;
    }

    public JSONObject getHttpBodyAsJson() throws JSONException {
        try {
            String string2 = new String(this.DA, "UTF-8");
            return new JSONObject(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"GoogleAuthApiRequest", (String)"Unsupported encoding error.");
            return null;
        }
    }

    public void setHttpBody(String string2) {
        try {
            this.DA = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"GoogleAuthApiRequest", (String)"Unsupported encoding error.");
        }
    }

    public long getTimeout() {
        return this.DB;
    }

    public void setTimeout(long timeout) {
        this.DB = timeout;
    }

    public String toString() {
        return "{ API: " + this.name + "/" + this.version + ", Scope: " + this.getFullScope() + ", Account: " + this.getAccountName() + " }";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        GoogleAuthApiRequestCreator.a(this, parcel, flags);
    }

    GoogleAuthApiRequest(int versionCode, String name, String version, String apiId, String path, Bundle parameters, String accountName, List<String> scopes, String scopePrefix, int httpMethod, Bundle headers, byte[] body, long timeout) {
        this.versionCode = versionCode;
        this.name = name;
        this.version = version;
        this.Dt = apiId;
        this.yR = path;
        this.Du = parameters;
        this.Dv = accountName;
        this.Dw = scopes;
        this.Dx = scopePrefix;
        this.Dy = httpMethod;
        this.Dz = headers;
        this.DA = body;
        this.DB = timeout;
    }
}

