/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.z;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class StandardExceptionParser
implements ExceptionParser {
    private final TreeSet<String> Bl = new TreeSet();

    public StandardExceptionParser(Context context, Collection<String> additionalPackages) {
        this.setIncludedPackages(context, additionalPackages);
    }

    public void setIncludedPackages(Context context, Collection<String> additionalPackages) {
        this.Bl.clear();
        HashSet<String> hashSet = new HashSet<String>();
        if (additionalPackages != null) {
            hashSet.addAll(additionalPackages);
        }
        if (context != null) {
            try {
                String string2 = context.getApplicationContext().getPackageName();
                this.Bl.add(string2);
                String string3 = context.getApplicationContext().getPackageManager().getPackageInfo(string2, 15);
                ActivityInfo[] activityInfoArray = ((PackageInfo)string3).activities;
                if (activityInfoArray != null) {
                    for (ActivityInfo activityInfo : activityInfoArray) {
                        hashSet.add(activityInfo.packageName);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                z.U("No package found");
            }
        }
        for (String string3 : hashSet) {
            boolean bl2 = true;
            for (String string4 : this.Bl) {
                if (!string3.startsWith(string4)) {
                    if (!string4.startsWith(string3)) break;
                    this.Bl.remove(string4);
                    break;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            this.Bl.add(string3);
        }
    }

    protected Throwable getCause(Throwable t2) {
        Throwable throwable = t2;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    protected StackTraceElement getBestStackTraceElement(Throwable t2) {
        StackTraceElement[] stackTraceElementArray = t2.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return null;
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string2 = stackTraceElement.getClassName();
            for (String string3 : this.Bl) {
                if (!string2.startsWith(string3)) continue;
                return stackTraceElement;
            }
        }
        return stackTraceElementArray[0];
    }

    protected String getDescription(Throwable cause, StackTraceElement element, String threadName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cause.getClass().getSimpleName());
        if (element != null) {
            String[] stringArray = element.getClassName().split("\\.");
            String string2 = "unknown";
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[stringArray.length - 1];
            }
            stringBuilder.append(String.format(" (@%s:%s:%s)", string2, element.getMethodName(), element.getLineNumber()));
        }
        if (threadName != null) {
            stringBuilder.append(String.format(" {%s}", threadName));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDescription(String threadName, Throwable t2) {
        return this.getDescription(this.getCause(t2), this.getBestStackTraceElement(this.getCause(t2)), threadName);
    }
}

