/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.z;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler xX;
    private final Tracker xY;
    private final Context mContext;
    private ExceptionParser xZ;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.xX = originalHandler;
        this.xY = tracker;
        this.xZ = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        z.V("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.xZ;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.xZ = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread t2, Throwable e2) {
        String string2 = "UncaughtException";
        if (this.xZ != null) {
            String string3 = t2 != null ? t2.getName() : null;
            string2 = this.xZ.getDescription(string3, e2);
        }
        z.V("Tracking Exception: " + string2);
        this.xY.send(new HitBuilders.ExceptionBuilder().setDescription(string2).setFatal(true).build());
        GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        if (this.xX != null) {
            z.V("Passing exception to original handler.");
            this.xX.uncaughtException(t2, e2);
        }
    }

    Thread.UncaughtExceptionHandler dZ() {
        return this.xX;
    }
}

