/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.a;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.internal.s;
import java.io.IOException;

public final class AdvertisingIdClient {
    final Context mContext;
    a lk;
    s ll;
    boolean lm;

    public AdvertisingIdClient(Context context) {
        n.i(context);
        this.mContext = context;
        this.lm = false;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        n.aU("Calling this from your main thread can lead to deadlock");
        if (this.lm) {
            this.finish();
        }
        this.lk = AdvertisingIdClient.i(this.mContext);
        this.ll = AdvertisingIdClient.a(this.mContext, this.lk);
        this.lm = true;
    }

    public Info W() throws IOException {
        n.aU("Calling this from your main thread can lead to deadlock");
        n.i(this.lk);
        n.i(this.ll);
        if (!this.lm) {
            throw new IOException("AdvertisingIdService is not connected.");
        }
        try {
            return new Info(this.ll.getId(), this.ll.a(true));
        }
        catch (RemoteException remoteException) {
            Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
            throw new IOException("Remote exception");
        }
    }

    public void finish() {
        n.aU("Calling this from your main thread can lead to deadlock");
        if (this.mContext == null || this.lk == null) {
            return;
        }
        try {
            if (this.lm) {
                this.mContext.unbindService((ServiceConnection)this.lk);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
        }
        this.lm = false;
        this.ll = null;
        this.lk = null;
    }

    static a i(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        try {
            object = context.getPackageManager();
            object.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        try {
            GooglePlayServicesUtil.D(context);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new IOException(googlePlayServicesNotAvailableException);
        }
        object = new a();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)object, 1)) {
            return object;
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context);
        try {
            advertisingIdClient.start();
            Info info = advertisingIdClient.W();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static s a(Context context, a a2) throws IOException {
        try {
            return s.a.b(a2.fX());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
    }

    public static final class Info {
        private final String ln;
        private final boolean lo;

        public Info(String advertisingId, boolean limitAdTrackingEnabled) {
            this.ln = advertisingId;
            this.lo = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.ln;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.lo;
        }

        public String toString() {
            return "{" + this.ln + "}" + this.lo;
        }
    }
}

