/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hm;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.e;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PutDataRequest
implements SafeParcelable {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new e();
    private static final Random aln = new SecureRandom();
    final int xM;
    private final Uri mUri;
    private final Bundle alo;
    private byte[] TF;

    PutDataRequest(int versionCode, Uri uri, Bundle assets, byte[] data) {
        this.xM = versionCode;
        this.mUri = uri;
        this.alo = assets;
        this.alo.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.TF = data;
    }

    private PutDataRequest(int versionCode, Uri uri) {
        this(versionCode, uri, new Bundle(), null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        e.a(this, dest, flags);
    }

    public static PutDataRequest createFromDataItem(DataItem source) {
        PutDataRequest putDataRequest = PutDataRequest.k(source.getUri());
        for (Map.Entry<String, DataItemAsset> entry : source.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                throw new IllegalStateException("Cannot create an asset for a put request without a digest: " + entry.getKey());
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(source.getData());
        return putDataRequest;
    }

    public static PutDataRequest k(Uri uri) {
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String pathPrefix) {
        StringBuilder stringBuilder = new StringBuilder(pathPrefix);
        if (!pathPrefix.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(aln.nextLong());
        Uri uri = PutDataRequest.cx(stringBuilder.toString());
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest create(String path) {
        Uri uri = PutDataRequest.cx(path);
        return PutDataRequest.k(uri);
    }

    private static Uri cx(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string2.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string2.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string2).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.TF;
    }

    public PutDataRequest setData(byte[] data) {
        this.TF = data;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string2 : this.alo.keySet()) {
            hashMap.put(string2, (Asset)this.alo.getParcelable(string2));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Bundle nm() {
        return this.alo;
    }

    public Asset getAsset(String key) {
        return (Asset)this.alo.getParcelable(key);
    }

    public boolean hasAsset(String key) {
        return this.alo.containsKey(key);
    }

    public PutDataRequest putAsset(String key, Asset value) {
        hm.f(key);
        hm.f(value);
        this.alo.putParcelable(key, (Parcelable)value);
        return this;
    }

    public PutDataRequest removeAsset(String key) {
        this.alo.remove(key);
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        stringBuilder.append("dataSz=" + (this.TF == null ? "null" : Integer.valueOf(this.TF.length)));
        stringBuilder.append(", numAssets=" + this.alo.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set set = this.alo.keySet();
        for (String string2 : set) {
            stringBuilder.append("\n    " + string2 + ": " + this.alo.getParcelable(string2));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

