/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import com.google.android.gms.maps.model.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int xM;
    private final List<LatLng> aaX;
    private final List<List<LatLng>> aaY;
    private float aau = 10.0f;
    private int aav = -16777216;
    private int aaw = 0;
    private float aax = 0.0f;
    private boolean aay = true;
    private boolean aaZ = false;

    public PolygonOptions() {
        this.xM = 1;
        this.aaX = new ArrayList<LatLng>();
        this.aaY = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.xM = versionCode;
        this.aaX = points;
        this.aaY = holes;
        this.aau = strokeWidth;
        this.aav = strokeColor;
        this.aaw = fillColor;
        this.aax = zIndex;
        this.aay = visible;
        this.aaZ = geodesic;
    }

    int getVersionCode() {
        return this.xM;
    }

    List jP() {
        return this.aaY;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.jL()) {
            g.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.aaX.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.aaX.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.aaX.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.aaY.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.aau = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.aav = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.aaw = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.aax = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.aay = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.aaZ = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.aaX;
    }

    public List<List<LatLng>> getHoles() {
        return this.aaY;
    }

    public float getStrokeWidth() {
        return this.aau;
    }

    public int getStrokeColor() {
        return this.aav;
    }

    public int getFillColor() {
        return this.aaw;
    }

    public float getZIndex() {
        return this.aax;
    }

    public boolean isVisible() {
        return this.aay;
    }

    public boolean isGeodesic() {
        return this.aaZ;
    }
}

