/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.location.Location;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.IProjectionDelegate;
import com.google.android.gms.maps.internal.IUiSettingsDelegate;
import com.google.android.gms.maps.internal.b;
import com.google.android.gms.maps.internal.d;
import com.google.android.gms.maps.internal.e;
import com.google.android.gms.maps.internal.f;
import com.google.android.gms.maps.internal.g;
import com.google.android.gms.maps.internal.i;
import com.google.android.gms.maps.internal.j;
import com.google.android.gms.maps.internal.k;
import com.google.android.gms.maps.internal.l;
import com.google.android.gms.maps.internal.m;
import com.google.android.gms.maps.internal.n;
import com.google.android.gms.maps.internal.o;
import com.google.android.gms.maps.internal.s;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.IPolylineDelegate;
import com.google.android.gms.maps.model.internal.b;
import com.google.android.gms.maps.model.internal.c;
import com.google.android.gms.maps.model.internal.d;
import com.google.android.gms.maps.model.internal.f;
import com.google.android.gms.maps.model.internal.g;
import com.google.android.gms.maps.model.internal.h;

public interface IGoogleMapDelegate
extends IInterface {
    public CameraPosition getCameraPosition() throws RemoteException;

    public float getMaxZoomLevel() throws RemoteException;

    public float getMinZoomLevel() throws RemoteException;

    public void moveCamera(com.google.android.gms.dynamic.d var1) throws RemoteException;

    public void animateCamera(com.google.android.gms.dynamic.d var1) throws RemoteException;

    public void animateCameraWithCallback(com.google.android.gms.dynamic.d var1, b var2) throws RemoteException;

    public void animateCameraWithDurationAndCallback(com.google.android.gms.dynamic.d var1, int var2, b var3) throws RemoteException;

    public void stopAnimation() throws RemoteException;

    public IPolylineDelegate addPolyline(PolylineOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.g addPolygon(PolygonOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.f addMarker(MarkerOptions var1) throws RemoteException;

    public c addGroundOverlay(GroundOverlayOptions var1) throws RemoteException;

    public h addTileOverlay(TileOverlayOptions var1) throws RemoteException;

    public void clear() throws RemoteException;

    public int getMapType() throws RemoteException;

    public void setMapType(int var1) throws RemoteException;

    public boolean isTrafficEnabled() throws RemoteException;

    public void setTrafficEnabled(boolean var1) throws RemoteException;

    public boolean isIndoorEnabled() throws RemoteException;

    public boolean setIndoorEnabled(boolean var1) throws RemoteException;

    public boolean isMyLocationEnabled() throws RemoteException;

    public void setMyLocationEnabled(boolean var1) throws RemoteException;

    public Location getMyLocation() throws RemoteException;

    public void setLocationSource(ILocationSourceDelegate var1) throws RemoteException;

    public IUiSettingsDelegate getUiSettings() throws RemoteException;

    public IProjectionDelegate getProjection() throws RemoteException;

    public void setOnCameraChangeListener(e var1) throws RemoteException;

    public void setOnMapClickListener(i var1) throws RemoteException;

    public void setOnMapLongClickListener(k var1) throws RemoteException;

    public void setOnMarkerClickListener(l var1) throws RemoteException;

    public void setOnMarkerDragListener(m var1) throws RemoteException;

    public void setOnInfoWindowClickListener(g var1) throws RemoteException;

    public void setInfoWindowAdapter(d var1) throws RemoteException;

    public com.google.android.gms.dynamic.d getTestingHelper() throws RemoteException;

    public com.google.android.gms.maps.model.internal.b addCircle(CircleOptions var1) throws RemoteException;

    public void setOnMyLocationChangeListener(o var1) throws RemoteException;

    public void setOnMyLocationButtonClickListener(n var1) throws RemoteException;

    public void snapshot(s var1, com.google.android.gms.dynamic.d var2) throws RemoteException;

    public void setPadding(int var1, int var2, int var3, int var4) throws RemoteException;

    public boolean isBuildingsEnabled() throws RemoteException;

    public void setBuildingsEnabled(boolean var1) throws RemoteException;

    public void setOnMapLoadedCallback(j var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.d getFocusedBuilding() throws RemoteException;

    public void setOnIndoorStateChangeListener(f var1) throws RemoteException;

    public void setWatermarkEnabled(boolean var1) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.IGoogleMapDelegate$a
    extends Binder
    implements IGoogleMapDelegate {
        public static IGoogleMapDelegate ay(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
            if (iInterface != null && iInterface instanceof IGoogleMapDelegate) {
                return (IGoogleMapDelegate)iInterface;
            }
            return new a(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraPosition cameraPosition = this.getCameraPosition();
                    reply.writeNoException();
                    if (cameraPosition != null) {
                        reply.writeInt(1);
                        cameraPosition.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f2 = this.getMaxZoomLevel();
                    reply.writeNoException();
                    reply.writeFloat(f2);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f3 = this.getMinZoomLevel();
                    reply.writeNoException();
                    reply.writeFloat(f3);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d2 = d.a.ag(data.readStrongBinder());
                    this.moveCamera(d2);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d3 = d.a.ag(data.readStrongBinder());
                    this.animateCamera(d3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d4 = d.a.ag(data.readStrongBinder());
                    b b2 = b.a.aw(data.readStrongBinder());
                    this.animateCameraWithCallback(d4, b2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d5 = d.a.ag(data.readStrongBinder());
                    int n2 = data.readInt();
                    b b3 = b.a.aw(data.readStrongBinder());
                    this.animateCameraWithDurationAndCallback(d5, n2, b3);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.stopAnimation();
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolylineOptions polylineOptions = 0 != data.readInt() ? PolylineOptions.CREATOR.createFromParcel(data) : null;
                    IPolylineDelegate iPolylineDelegate = this.addPolyline(polylineOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(iPolylineDelegate != null ? iPolylineDelegate.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolygonOptions polygonOptions = 0 != data.readInt() ? PolygonOptions.CREATOR.createFromParcel(data) : null;
                    com.google.android.gms.maps.model.internal.g g2 = this.addPolygon(polygonOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(g2 != null ? g2.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    MarkerOptions markerOptions = 0 != data.readInt() ? MarkerOptions.CREATOR.createFromParcel(data) : null;
                    com.google.android.gms.maps.model.internal.f f4 = this.addMarker(markerOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(f4 != null ? f4.asBinder() : null);
                    return true;
                }
                case 12: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    GroundOverlayOptions groundOverlayOptions = 0 != data.readInt() ? GroundOverlayOptions.CREATOR.createFromParcel(data) : null;
                    c c2 = this.addGroundOverlay(groundOverlayOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(c2 != null ? c2.asBinder() : null);
                    return true;
                }
                case 13: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    TileOverlayOptions tileOverlayOptions = 0 != data.readInt() ? TileOverlayOptions.CREATOR.createFromParcel(data) : null;
                    h h2 = this.addTileOverlay(tileOverlayOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(h2 != null ? h2.asBinder() : null);
                    return true;
                }
                case 14: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.clear();
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n3 = this.getMapType();
                    reply.writeNoException();
                    reply.writeInt(n3);
                    return true;
                }
                case 16: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n4 = data.readInt();
                    this.setMapType(n4);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl2 = this.isTrafficEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl2 ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl3 = 0 != data.readInt();
                    this.setTrafficEnabled(bl3);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl4 = this.isIndoorEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl4 ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl5 = 0 != data.readInt();
                    boolean bl6 = this.setIndoorEnabled(bl5);
                    reply.writeNoException();
                    reply.writeInt(bl6 ? 1 : 0);
                    return true;
                }
                case 21: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl7 = this.isMyLocationEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl7 ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl8 = 0 != data.readInt();
                    this.setMyLocationEnabled(bl8);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Location location = this.getMyLocation();
                    reply.writeNoException();
                    if (location != null) {
                        reply.writeInt(1);
                        location.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    ILocationSourceDelegate iLocationSourceDelegate = ILocationSourceDelegate.a.aA(data.readStrongBinder());
                    this.setLocationSource(iLocationSourceDelegate);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IUiSettingsDelegate iUiSettingsDelegate = this.getUiSettings();
                    reply.writeNoException();
                    reply.writeStrongBinder(iUiSettingsDelegate != null ? iUiSettingsDelegate.asBinder() : null);
                    return true;
                }
                case 26: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IProjectionDelegate iProjectionDelegate = this.getProjection();
                    reply.writeNoException();
                    reply.writeStrongBinder(iProjectionDelegate != null ? iProjectionDelegate.asBinder() : null);
                    return true;
                }
                case 27: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    e e2 = e.a.aD(data.readStrongBinder());
                    this.setOnCameraChangeListener(e2);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    i i2 = i.a.aH(data.readStrongBinder());
                    this.setOnMapClickListener(i2);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    k k2 = k.a.aJ(data.readStrongBinder());
                    this.setOnMapLongClickListener(k2);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    l l2 = l.a.aK(data.readStrongBinder());
                    this.setOnMarkerClickListener(l2);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    m m2 = m.a.aL(data.readStrongBinder());
                    this.setOnMarkerDragListener(m2);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    g g3 = g.a.aF(data.readStrongBinder());
                    this.setOnInfoWindowClickListener(g3);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    d d6 = d.a.az(data.readStrongBinder());
                    this.setInfoWindowAdapter(d6);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d7 = this.getTestingHelper();
                    reply.writeNoException();
                    reply.writeStrongBinder(d7 != null ? d7.asBinder() : null);
                    return true;
                }
                case 35: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CircleOptions circleOptions = 0 != data.readInt() ? CircleOptions.CREATOR.createFromParcel(data) : null;
                    com.google.android.gms.maps.model.internal.b b4 = this.addCircle(circleOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(b4 != null ? b4.asBinder() : null);
                    return true;
                }
                case 36: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    o o2 = o.a.aN(data.readStrongBinder());
                    this.setOnMyLocationChangeListener(o2);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    n n5 = n.a.aM(data.readStrongBinder());
                    this.setOnMyLocationButtonClickListener(n5);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    s s2 = s.a.aS(data.readStrongBinder());
                    com.google.android.gms.dynamic.d d8 = d.a.ag(data.readStrongBinder());
                    this.snapshot(s2, d8);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n6 = data.readInt();
                    int n7 = data.readInt();
                    int n8 = data.readInt();
                    int n9 = data.readInt();
                    this.setPadding(n6, n7, n8, n9);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl9 = this.isBuildingsEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl9 ? 1 : 0);
                    return true;
                }
                case 41: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl10 = 0 != data.readInt();
                    this.setBuildingsEnabled(bl10);
                    reply.writeNoException();
                    return true;
                }
                case 42: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    j j2 = j.a.aI(data.readStrongBinder());
                    this.setOnMapLoadedCallback(j2);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.maps.model.internal.d d9 = this.getFocusedBuilding();
                    reply.writeNoException();
                    reply.writeStrongBinder(d9 != null ? d9.asBinder() : null);
                    return true;
                }
                case 45: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    f f5 = f.a.aE(data.readStrongBinder());
                    this.setOnIndoorStateChangeListener(f5);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl11 = 0 != data.readInt();
                    this.setWatermarkEnabled(bl11);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class a
        implements IGoogleMapDelegate {
            private IBinder kq;

            a(IBinder iBinder) {
                this.kq = iBinder;
            }

            public IBinder asBinder() {
                return this.kq;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraPosition getCameraPosition() throws RemoteException {
                CameraPosition cameraPosition;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    cameraPosition = 0 != parcel2.readInt() ? CameraPosition.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return cameraPosition;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMaxZoomLevel() throws RemoteException {
                float f2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    f2 = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMinZoomLevel() throws RemoteException {
                float f2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    f2 = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveCamera(com.google.android.gms.dynamic.d update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    this.kq.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCamera(com.google.android.gms.dynamic.d update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    this.kq.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithCallback(com.google.android.gms.dynamic.d update, b callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.kq.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithDurationAndCallback(com.google.android.gms.dynamic.d update, int durationMs, b callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    parcel.writeInt(durationMs);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.kq.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopAnimation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPolylineDelegate addPolyline(PolylineOptions options) throws RemoteException {
                IPolylineDelegate iPolylineDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.kq.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    iPolylineDelegate = IPolylineDelegate.a.be(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iPolylineDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.g addPolygon(PolygonOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.g g2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.kq.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    g2 = g.a.bd(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return g2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.f addMarker(MarkerOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.f f2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.kq.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    f2 = f.a.bc(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public c addGroundOverlay(GroundOverlayOptions options) throws RemoteException {
                c c2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.kq.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    c2 = c.a.aZ(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return c2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public h addTileOverlay(TileOverlayOptions options) throws RemoteException {
                h h2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.kq.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    h2 = h.a.bf(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return h2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMapType() throws RemoteException {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMapType(int type) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(type);
                    this.kq.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTrafficEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTrafficEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.kq.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isIndoorEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setIndoorEnabled(boolean enabled) throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.kq.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMyLocationEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMyLocationEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.kq.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Location getMyLocation() throws RemoteException {
                Location location;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    location = 0 != parcel2.readInt() ? (Location)Location.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return location;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLocationSource(ILocationSourceDelegate source) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(source != null ? source.asBinder() : null);
                    this.kq.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IUiSettingsDelegate getUiSettings() throws RemoteException {
                IUiSettingsDelegate iUiSettingsDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    iUiSettingsDelegate = IUiSettingsDelegate.a.aW(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iUiSettingsDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IProjectionDelegate getProjection() throws RemoteException {
                IProjectionDelegate iProjectionDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    iProjectionDelegate = IProjectionDelegate.a.aR(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iProjectionDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnCameraChangeListener(e listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapClickListener(i listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapLongClickListener(k listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMarkerClickListener(l listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMarkerDragListener(m listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnInfoWindowClickListener(g listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInfoWindowAdapter(d adapter) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(adapter != null ? adapter.asBinder() : null);
                    this.kq.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.dynamic.d getTestingHelper() throws RemoteException {
                com.google.android.gms.dynamic.d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ag(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.b addCircle(CircleOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.b b2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.kq.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    b2 = b.a.aY(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return b2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMyLocationChangeListener(o listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMyLocationButtonClickListener(n listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void snapshot(s callback, com.google.android.gms.dynamic.d bitmap) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    parcel.writeStrongBinder(bitmap != null ? bitmap.asBinder() : null);
                    this.kq.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPadding(int left, int top, int right, int bottom) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(left);
                    parcel.writeInt(top);
                    parcel.writeInt(right);
                    parcel.writeInt(bottom);
                    this.kq.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBuildingsEnabled() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBuildingsEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.kq.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapLoadedCallback(j callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.kq.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.d getFocusedBuilding() throws RemoteException {
                com.google.android.gms.maps.model.internal.d d2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.kq.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    d2 = d.a.ba(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return d2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnIndoorStateChangeListener(f listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.kq.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWatermarkEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.kq.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

