/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int xM;
    private Boolean Zs;
    private Boolean Zt;
    private int Zu = -1;
    private CameraPosition Zv;
    private Boolean Zw;
    private Boolean Zx;
    private Boolean Zy;
    private Boolean Zz;
    private Boolean ZA;
    private Boolean ZB;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.xM = versionCode;
        this.Zs = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.Zt = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.Zu = mapType;
        this.Zv = camera;
        this.Zw = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.Zx = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.Zy = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.Zz = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.ZA = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.ZB = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.jL()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.xM;
    }

    byte jq() {
        return com.google.android.gms.maps.internal.a.c(this.Zs);
    }

    byte jr() {
        return com.google.android.gms.maps.internal.a.c(this.Zt);
    }

    byte js() {
        return com.google.android.gms.maps.internal.a.c(this.Zw);
    }

    byte jt() {
        return com.google.android.gms.maps.internal.a.c(this.Zx);
    }

    byte ju() {
        return com.google.android.gms.maps.internal.a.c(this.Zy);
    }

    byte jv() {
        return com.google.android.gms.maps.internal.a.c(this.Zz);
    }

    byte jw() {
        return com.google.android.gms.maps.internal.a.c(this.ZA);
    }

    byte jx() {
        return com.google.android.gms.maps.internal.a.c(this.ZB);
    }

    public GoogleMapOptions() {
        this.xM = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.Zs = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.Zt = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.Zu = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.Zv = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.Zw = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.Zx = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.Zy = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.Zz = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.ZA = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.ZB = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.Zs;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.Zt;
    }

    public int getMapType() {
        return this.Zu;
    }

    public CameraPosition getCamera() {
        return this.Zv;
    }

    public Boolean getZoomControlsEnabled() {
        return this.Zw;
    }

    public Boolean getCompassEnabled() {
        return this.Zx;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.Zy;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.Zz;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.ZA;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.ZB;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

