/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hk;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int xM;
    int mPriority;
    long Vl;
    long Vm;
    boolean Vn;
    long Vb;
    int Vo;
    float Vp;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.xM = 1;
        this.mPriority = 102;
        this.Vl = 3600000L;
        this.Vm = 600000L;
        this.Vn = false;
        this.Vb = Long.MAX_VALUE;
        this.Vo = Integer.MAX_VALUE;
        this.Vp = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.cG(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.v(millis);
        this.Vl = millis;
        if (!this.Vn) {
            this.Vm = (long)((double)this.Vl / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.Vl;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.v(millis);
        this.Vn = true;
        this.Vm = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.Vm;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.Vb = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.Vb < 0L) {
            this.Vb = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.Vb = millis;
        if (this.Vb < 0L) {
            this.Vb = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.Vb;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.Vo = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.Vo;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.Vp = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.Vp;
    }

    private static void v(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void cG(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.xM = versionCode;
        this.mPriority = priority;
        this.Vl = interval;
        this.Vm = fastestInterval;
        this.Vn = explicitFastestInterval;
        this.Vb = expireAt;
        this.Vo = numUpdates;
        this.Vp = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String cH(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.cH(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.Vl + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.Vm + "ms");
        if (this.Vb != Long.MAX_VALUE) {
            long l2 = this.Vb - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.Vo != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.Vo);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return hk.hashCode(this.mPriority, this.Vl, this.Vm, this.Vn, this.Vb, this.Vo, Float.valueOf(this.Vp));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.Vl == locationRequest.Vl && this.Vm == locationRequest.Vm && this.Vn == locationRequest.Vn && this.Vb == locationRequest.Vb && this.Vo == locationRequest.Vo && this.Vp == locationRequest.Vp;
    }

    int getVersionCode() {
        return this.xM;
    }
}

