/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.ik;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final SnapshotMetadataEntityCreator CREATOR = new SnapshotMetadataEntityCreator();
    private final int xM;
    private final GameEntity Rt;
    private final PlayerEntity Ul;
    private final String NK;
    private final Uri Uh;
    private final String Um;
    private final String HY;
    private final String Mp;
    private final long Un;
    private final long Uo;
    private final float Up;
    private final String Uq;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.xM = 3;
        this.Rt = new GameEntity(snapshotMetadata.getGame());
        this.Ul = new PlayerEntity(snapshotMetadata.getOwner());
        this.NK = snapshotMetadata.getSnapshotId();
        this.Uh = snapshotMetadata.getCoverImageUri();
        this.Um = snapshotMetadata.getCoverImageUrl();
        this.Up = snapshotMetadata.getCoverImageAspectRatio();
        this.HY = snapshotMetadata.getTitle();
        this.Mp = snapshotMetadata.getDescription();
        this.Un = snapshotMetadata.getLastModifiedTimestamp();
        this.Uo = snapshotMetadata.getPlayedTime();
        this.Uq = snapshotMetadata.getUniqueName();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName) {
        this.xM = versionCode;
        this.Rt = game;
        this.Ul = owner;
        this.NK = snapshotId;
        this.Uh = coverImageUri;
        this.Um = coverImageUrl;
        this.Up = coverImageAspectRatio;
        this.HY = title;
        this.Mp = description;
        this.Un = lastModifiedTimestamp;
        this.Uo = playedTime;
        this.Uq = uniqueName;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public Game getGame() {
        return this.Rt;
    }

    @Override
    public Player getOwner() {
        return this.Ul;
    }

    @Override
    public String getSnapshotId() {
        return this.NK;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.Uh;
    }

    @Override
    public String getCoverImageUrl() {
        return this.Um;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.Up;
    }

    @Override
    public String getUniqueName() {
        return this.Uq;
    }

    @Override
    public String getTitle() {
        return this.HY;
    }

    @Override
    public String getDescription() {
        return this.Mp;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        ik.b(this.Mp, dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.Un;
    }

    @Override
    public long getPlayedTime() {
        return this.Uo;
    }

    @Override
    public SnapshotMetadata freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.a(this);
    }

    static int a(SnapshotMetadata snapshotMetadata) {
        return hk.hashCode(snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName());
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.a(this, obj);
    }

    static boolean a(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return hk.equal(snapshotMetadata2.getGame(), snapshotMetadata.getGame()) && hk.equal(snapshotMetadata2.getOwner(), snapshotMetadata.getOwner()) && hk.equal(snapshotMetadata2.getSnapshotId(), snapshotMetadata.getSnapshotId()) && hk.equal(snapshotMetadata2.getCoverImageUri(), snapshotMetadata.getCoverImageUri()) && hk.equal(Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && hk.equal(snapshotMetadata2.getTitle(), snapshotMetadata.getTitle()) && hk.equal(snapshotMetadata2.getDescription(), snapshotMetadata.getDescription()) && hk.equal(snapshotMetadata2.getLastModifiedTimestamp(), snapshotMetadata.getLastModifiedTimestamp()) && hk.equal(snapshotMetadata2.getPlayedTime(), snapshotMetadata.getPlayedTime()) && hk.equal(snapshotMetadata2.getUniqueName(), snapshotMetadata.getUniqueName());
    }

    public String toString() {
        return SnapshotMetadataEntity.b(this);
    }

    static String b(SnapshotMetadata snapshotMetadata) {
        return hk.e(snapshotMetadata).a("Game", snapshotMetadata.getGame()).a("Owner", snapshotMetadata.getOwner()).a("SnapshotId", snapshotMetadata.getSnapshotId()).a("CoverImageUri", snapshotMetadata.getCoverImageUri()).a("CoverImageUrl", snapshotMetadata.getCoverImageUrl()).a("CoverImageAspectRatio", Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).a("Description", snapshotMetadata.getDescription()).a("LastModifiedTimestamp", snapshotMetadata.getLastModifiedTimestamp()).a("PlayedTime", snapshotMetadata.getPlayedTime()).a("UniqueName", snapshotMetadata.getUniqueName()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.a(this, out, flags);
    }
}

