/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.a;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeCreator;
import com.google.android.gms.internal.hm;

public final class SnapshotMetadataChange
implements SafeParcelable {
    public static final SnapshotMetadataChangeCreator CREATOR = new SnapshotMetadataChangeCreator();
    private final int xM;
    private final String Mp;
    private final Long Ug;
    private final Uri Uh;
    private a Ui;
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChange();

    SnapshotMetadataChange() {
        this(4, null, null, null, null);
    }

    SnapshotMetadataChange(String description, Long playedTimeMillis, a coverImage, Uri coverImageUri) {
        this(4, description, playedTimeMillis, coverImage, coverImageUri);
    }

    SnapshotMetadataChange(int versionCode, String description, Long playedTimeMillis, a coverImage, Uri coverImageUri) {
        this.xM = versionCode;
        this.Mp = description;
        this.Ug = playedTimeMillis;
        this.Ui = coverImage;
        this.Uh = coverImageUri;
        if (this.Ui != null) {
            hm.a(this.Uh == null, "Cannot set both a URI and an image");
        } else if (this.Uh != null) {
            hm.a(this.Ui == null, "Cannot set both a URI and an image");
        }
    }

    public int getVersionCode() {
        return this.xM;
    }

    public String getDescription() {
        return this.Mp;
    }

    public Long getPlayedTimeMillis() {
        return this.Ug;
    }

    public a iN() {
        return this.Ui;
    }

    public Bitmap getCoverImage() {
        return this.Ui == null ? null : this.Ui.eS();
    }

    public Uri getCoverImageUri() {
        return this.Uh;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataChangeCreator.a(this, out, flags);
    }

    public static final class Builder {
        private String Mp;
        private Long Uj;
        private a Uk;
        private Uri Uh;

        public Builder setDescription(String description) {
            this.Mp = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.Uj = playedTimeMillis;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.Uk = new a(coverImage);
            this.Uh = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.Mp = metadata.getDescription();
            this.Uj = metadata.getPlayedTime();
            if (this.Uj == -1L) {
                this.Uj = null;
            }
            this.Uh = metadata.getCoverImageUri();
            if (this.Uh != null) {
                this.Uk = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChange(this.Mp, this.Uj, this.Uk, this.Uh);
        }
    }
}

