/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.ik;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int xM;
    private final GameEntity Rt;
    private final String Oi;
    private final String Ts;
    private final long SU;
    private final String TA;
    private final long TB;
    private final String TC;
    private final int TD;
    private final int SY;
    private final int TE;
    private final byte[] TF;
    private final ArrayList<ParticipantEntity> SX;
    private final String TG;
    private final byte[] TH;
    private final int TI;
    private final Bundle To;
    private final int TJ;
    private final boolean TK;
    private final String Mp;
    private final String TL;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.xM = 2;
        this.Rt = new GameEntity(match.getGame());
        this.Oi = match.getMatchId();
        this.Ts = match.getCreatorId();
        this.SU = match.getCreationTimestamp();
        this.TA = match.getLastUpdaterId();
        this.TB = match.getLastUpdatedTimestamp();
        this.TC = match.getPendingParticipantId();
        this.TD = match.getStatus();
        this.TJ = match.getTurnStatus();
        this.SY = match.getVariant();
        this.TE = match.getVersion();
        this.TG = match.getRematchId();
        this.TI = match.getMatchNumber();
        this.To = match.getAutoMatchCriteria();
        this.TK = match.isLocallyModified();
        this.Mp = match.getDescription();
        this.TL = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.TF = null;
        } else {
            this.TF = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.TF, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.TH = null;
        } else {
            this.TH = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.TH, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n2 = arrayList.size();
        this.SX = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.SX.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.xM = versionCode;
        this.Rt = game;
        this.Oi = matchId;
        this.Ts = creatorId;
        this.SU = creationTimestamp;
        this.TA = lastUpdaterId;
        this.TB = lastUpdatedTimestamp;
        this.TC = pendingParticipantId;
        this.TD = matchStatus;
        this.TJ = turnStatus;
        this.SY = variant;
        this.TE = version;
        this.TF = data;
        this.SX = participants;
        this.TG = rematchId;
        this.TH = previousData;
        this.TI = matchNumber;
        this.To = autoMatchCriteria;
        this.TK = isLocallyModified;
        this.Mp = description;
        this.TL = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public Game getGame() {
        return this.Rt;
    }

    @Override
    public String getMatchId() {
        return this.Oi;
    }

    @Override
    public String getCreatorId() {
        return this.Ts;
    }

    @Override
    public long getCreationTimestamp() {
        return this.SU;
    }

    @Override
    public String getLastUpdaterId() {
        return this.TA;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.TB;
    }

    @Override
    public String getPendingParticipantId() {
        return this.TC;
    }

    @Override
    public int getStatus() {
        return this.TD;
    }

    @Override
    public int getTurnStatus() {
        return this.TJ;
    }

    @Override
    public String getDescription() {
        return this.Mp;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.TL;
    }

    @Override
    public Participant getDescriptionParticipant() {
        return this.getParticipant(this.getDescriptionParticipantId());
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        ik.b(this.Mp, dataOut);
    }

    @Override
    public int getVariant() {
        return this.SY;
    }

    @Override
    public byte[] getData() {
        return this.TF;
    }

    @Override
    public int getVersion() {
        return this.TE;
    }

    @Override
    public String getRematchId() {
        return this.TG;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.TH;
    }

    @Override
    public int getMatchNumber() {
        return this.TI;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.To;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.To == null) {
            return 0;
        }
        return this.To.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.TD == 2 && this.TG == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.TK;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.SX);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return hk.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return hk.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && hk.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && hk.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && hk.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && hk.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && hk.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && hk.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && hk.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && hk.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && hk.equal(turnBasedMatch2.getDescription(), turnBasedMatch.getDescription()) && hk.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && hk.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && hk.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && hk.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && hk.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && hk.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && hk.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && hk.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return hk.e(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Description", turnBasedMatch.getDescription()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).a("DescriptionParticipantId", turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string2) {
        String string3 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }
}

