/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.hm;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener Tk;
    private final RoomStatusUpdateListener Tl;
    private final RealTimeMessageReceivedListener Tm;
    private final String NQ;
    private final int SY;
    private final String[] Tn;
    private final Bundle To;
    private final boolean Tp;

    private RoomConfig(Builder builder) {
        this.Tk = builder.Tk;
        this.Tl = builder.Tl;
        this.Tm = builder.Tm;
        this.NQ = builder.Tq;
        this.SY = builder.SY;
        this.To = builder.To;
        this.Tp = builder.Tp;
        int n2 = builder.Tr.size();
        this.Tn = builder.Tr.toArray(new String[n2]);
        if (this.Tm == null) {
            hm.a(this.Tp, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.Tk;
    }

    public String getInvitationId() {
        return this.NQ;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.Tl;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.Tm;
    }

    public int getVariant() {
        return this.SY;
    }

    public String[] getInvitedPlayerIds() {
        return this.Tn;
    }

    public Bundle getAutoMatchCriteria() {
        return this.To;
    }

    public boolean isSocketEnabled() {
        return this.Tp;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener Tk;
        RoomStatusUpdateListener Tl;
        RealTimeMessageReceivedListener Tm;
        String Tq = null;
        int SY = -1;
        ArrayList<String> Tr = new ArrayList();
        Bundle To;
        boolean Tp = false;

        private Builder(RoomUpdateListener updateListener) {
            this.Tk = hm.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            hm.f(invitationId);
            this.Tq = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.Tl = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.Tm = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            hm.f(playerIds);
            this.Tr.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            hm.f(playerIds);
            this.Tr.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            hm.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.SY = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.Tp = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.To = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

