/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.hm;
import com.google.android.gms.internal.ik;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long Su;
    private final String Sv;
    private final String Sw;
    private final long Sx;
    private final long Sy;
    private final String Sz;
    private final Uri SA;
    private final Uri SB;
    private final PlayerEntity SC;
    private final String SD;
    private final String SE;
    private final String SF;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.Su = score.getRank();
        this.Sv = hm.f(score.getDisplayRank());
        this.Sw = hm.f(score.getDisplayScore());
        this.Sx = score.getRawScore();
        this.Sy = score.getTimestampMillis();
        this.Sz = score.getScoreHolderDisplayName();
        this.SA = score.getScoreHolderIconImageUri();
        this.SB = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.SC = player == null ? null : (PlayerEntity)player.freeze();
        this.SD = score.getScoreTag();
        this.SE = score.getScoreHolderIconImageUrl();
        this.SF = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.Su;
    }

    @Override
    public String getDisplayRank() {
        return this.Sv;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        ik.b(this.Sv, dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.Sw;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        ik.b(this.Sw, dataOut);
    }

    @Override
    public long getRawScore() {
        return this.Sx;
    }

    @Override
    public long getTimestampMillis() {
        return this.Sy;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.SC == null) {
            return this.Sz;
        }
        return this.SC.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.SC == null) {
            ik.b(this.Sz, dataOut);
            return;
        }
        this.SC.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.SC == null) {
            return this.SA;
        }
        return this.SC.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.SC == null) {
            return this.SE;
        }
        return this.SC.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.SC == null) {
            return this.SB;
        }
        return this.SC.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.SC == null) {
            return this.SF;
        }
        return this.SC.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.SC;
    }

    @Override
    public String getScoreTag() {
        return this.SD;
    }

    public LeaderboardScore iC() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return hk.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return hk.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && hk.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && hk.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && hk.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && hk.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && hk.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && hk.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && hk.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && hk.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && hk.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return hk.e(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("IconImageUrl", leaderboardScore.getScoreHolderIconImageUrl()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("HiResImageUrl", leaderboardScore.getScoreHolderHiResImageUrl()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.iC();
    }
}

