/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantRef;
import java.util.ArrayList;

public final class LeaderboardRef
extends d
implements Leaderboard {
    private final int RG;
    private final Game Ss;

    LeaderboardRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.RG = numChildren;
        this.Ss = new GameRef(holder, dataRow);
    }

    @Override
    public String getLeaderboardId() {
        return this.getString("external_leaderboard_id");
    }

    @Override
    public String getDisplayName() {
        return this.getString("name");
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.a("name", dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.aw("board_icon_image_uri");
    }

    @Override
    public String getIconImageUrl() {
        return this.getString("board_icon_image_url");
    }

    @Override
    public int getScoreOrder() {
        return this.getInteger("score_order");
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        ArrayList<LeaderboardVariant> arrayList = new ArrayList<LeaderboardVariant>(this.RG);
        for (int i2 = 0; i2 < this.RG; ++i2) {
            arrayList.add(new LeaderboardVariantRef(this.DG, this.EC + i2));
        }
        return arrayList;
    }

    @Override
    public Game getGame() {
        return this.Ss;
    }

    public Leaderboard iz() {
        return new LeaderboardEntity(this);
    }

    @Override
    public int hashCode() {
        return LeaderboardEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return LeaderboardEntity.a(this, obj);
    }

    public String toString() {
        return LeaderboardEntity.b(this);
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.iz();
    }
}

