/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.ik;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String Sp;
    private final String Ln;
    private final Uri Mr;
    private final int Sq;
    private final ArrayList<LeaderboardVariantEntity> Sr;
    private final Game Ss;
    private final String MC;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.Sp = leaderboard.getLeaderboardId();
        this.Ln = leaderboard.getDisplayName();
        this.Mr = leaderboard.getIconImageUri();
        this.MC = leaderboard.getIconImageUrl();
        this.Sq = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.Ss = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n2 = arrayList.size();
        this.Sr = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.Sr.add((LeaderboardVariantEntity)arrayList.get(i2).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.Sp;
    }

    @Override
    public String getDisplayName() {
        return this.Ln;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        ik.b(this.Ln, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mr;
    }

    @Override
    public String getIconImageUrl() {
        return this.MC;
    }

    @Override
    public int getScoreOrder() {
        return this.Sq;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.Sr);
    }

    @Override
    public Game getGame() {
        return this.Ss;
    }

    public Leaderboard iz() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.a(this);
    }

    static int a(Leaderboard leaderboard) {
        return hk.hashCode(leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants());
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.a(this, obj);
    }

    static boolean a(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return hk.equal(leaderboard2.getLeaderboardId(), leaderboard.getLeaderboardId()) && hk.equal(leaderboard2.getDisplayName(), leaderboard.getDisplayName()) && hk.equal(leaderboard2.getIconImageUri(), leaderboard.getIconImageUri()) && hk.equal(leaderboard2.getScoreOrder(), leaderboard.getScoreOrder()) && hk.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.b(this);
    }

    static String b(Leaderboard leaderboard) {
        return hk.e(leaderboard).a("LeaderboardId", leaderboard.getLeaderboardId()).a("DisplayName", leaderboard.getDisplayName()).a("IconImageUri", leaderboard.getIconImageUri()).a("IconImageUrl", leaderboard.getIconImageUrl()).a("ScoreOrder", leaderboard.getScoreOrder()).a("Variants", leaderboard.getVariants()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.iz();
    }
}

