/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntityCreator;
import com.google.android.gms.internal.hk;

public final class GameBadgeEntity
extends GamesDowngradeableSafeParcel
implements GameBadge {
    public static final GameBadgeEntityCreator CREATOR = new GameBadgeEntityCreatorCompat();
    private final int xM;
    private int AT;
    private String HY;
    private String Mp;
    private Uri Mr;

    public GameBadgeEntity(GameBadge gameBadge) {
        this.xM = 1;
        this.AT = gameBadge.getType();
        this.HY = gameBadge.getTitle();
        this.Mp = gameBadge.getDescription();
        this.Mr = gameBadge.getIconImageUri();
    }

    GameBadgeEntity(int versionCode, int type, String title, String description, Uri iconImageUri) {
        this.xM = versionCode;
        this.AT = type;
        this.HY = title;
        this.Mp = description;
        this.Mr = iconImageUri;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public int getType() {
        return this.AT;
    }

    @Override
    public String getTitle() {
        return this.HY;
    }

    @Override
    public String getDescription() {
        return this.Mp;
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mr;
    }

    public GameBadge ic() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameBadgeEntity.a(this);
    }

    static int a(GameBadge gameBadge) {
        return hk.hashCode(gameBadge.getType(), gameBadge.getTitle(), gameBadge.getDescription(), gameBadge.getIconImageUri());
    }

    public boolean equals(Object obj) {
        return GameBadgeEntity.a(this, obj);
    }

    static boolean a(GameBadge gameBadge, Object object) {
        if (!(object instanceof GameBadge)) {
            return false;
        }
        if (gameBadge == object) {
            return true;
        }
        GameBadge gameBadge2 = (GameBadge)object;
        return hk.equal(gameBadge2.getType(), gameBadge.getTitle()) && hk.equal(gameBadge2.getDescription(), gameBadge.getIconImageUri());
    }

    public String toString() {
        return GameBadgeEntity.b(this);
    }

    static String b(GameBadge gameBadge) {
        return hk.e(gameBadge).a("Type", gameBadge.getType()).a("Title", gameBadge.getTitle()).a("Description", gameBadge.getDescription()).a("IconImageUri", gameBadge.getIconImageUri()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fr()) {
            GameBadgeEntityCreator.a(this, dest, flags);
        } else {
            dest.writeInt(this.AT);
            dest.writeString(this.HY);
            dest.writeString(this.Mp);
            dest.writeString(this.Mr == null ? null : this.Mr.toString());
        }
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.ic();
    }

    static final class GameBadgeEntityCreatorCompat
    extends GameBadgeEntityCreator {
        GameBadgeEntityCreatorCompat() {
        }

        @Override
        public GameBadgeEntity bh(Parcel parcel) {
            boolean bl2 = GameBadgeEntity.c(GameBadgeEntity.fq());
            if (bl2 || GameBadgeEntity.aA(GameBadgeEntity.class.getCanonicalName())) {
                return super.bh(parcel);
            }
            int n2 = parcel.readInt();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            return new GameBadgeEntity(1, n2, string2, string3, uri);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bh(x0);
        }
    }
}

