/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.net.LocalSocket;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class RealTimeSocketImpl
implements RealTimeSocket {
    private final LocalSocket Pd;
    private final String Oq;
    private ParcelFileDescriptor Fj;

    RealTimeSocketImpl(LocalSocket localSocket, String participantId) {
        this.Pd = localSocket;
        this.Oq = participantId;
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() throws IOException {
        if (this.Fj == null && !this.isClosed()) {
            Parcel parcel = Parcel.obtain();
            parcel.writeFileDescriptor(this.Pd.getFileDescriptor());
            parcel.setDataPosition(0);
            this.Fj = parcel.readFileDescriptor();
        }
        return this.Fj;
    }

    @Override
    public void close() throws IOException {
        this.Pd.close();
    }

    @Override
    public boolean isClosed() {
        return !this.Pd.isConnected() && !this.Pd.isBound();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.Pd.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.Pd.getOutputStream();
    }
}

