/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends d
implements Player {
    private final PlayerColumnNames Ng;
    private final PlayerLevelInfo MX;
    private final MostRecentGameInfoRef Nh;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.Ng = new PlayerColumnNames(prefix);
        this.Nh = new MostRecentGameInfoRef(holder, dataRow, this.Ng);
        if (this.gV()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.Ng.RY);
            int n3 = this.getInteger(this.Ng.Sb);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.Ng.RZ), this.getLong(this.Ng.Sa));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.Ng.Sa), this.getLong(this.Ng.Sc));
            }
            this.MX = new PlayerLevelInfo(this.getLong(this.Ng.RX), this.getLong(this.Ng.Sd), playerLevel, playerLevel2);
        } else {
            this.MX = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.Ng.RO);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.Ng.RP);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.a(this.Ng.RP, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.aw(this.Ng.RQ);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.Ng.RR);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.aw(this.Ng.RS);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.Ng.RT);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.Ng.RU);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.av(this.Ng.RW) || this.ax(this.Ng.RW)) {
            return -1L;
        }
        return this.getLong(this.Ng.RW);
    }

    @Override
    public int gS() {
        return this.getInteger(this.Ng.RV);
    }

    @Override
    public boolean gT() {
        return this.getBoolean(this.Ng.Sf);
    }

    @Override
    public String getTitle() {
        return this.getString(this.Ng.Se);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.a(this.Ng.Se, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.MX;
    }

    @Override
    public MostRecentGameInfo gU() {
        if (this.ax(this.Ng.Sg)) {
            return null;
        }
        return this.Nh;
    }

    @Override
    public Player freeze() {
        return new PlayerEntity(this);
    }

    @Override
    public int hashCode() {
        return PlayerEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean gV() {
        if (this.ax(this.Ng.RX)) {
            return false;
        }
        return this.getLong(this.Ng.RX) != -1L;
    }
}

