/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.gx;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.ik;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int xM;
    private final String MS;
    private final String Ln;
    private final Uri Mr;
    private final Uri Ms;
    private final long MT;
    private final int MU;
    private final long MV;
    private final String MC;
    private final String MD;
    private final String HY;
    private final MostRecentGameInfoEntity MW;
    private final PlayerLevelInfo MX;
    private final boolean MY;

    public PlayerEntity(Player player) {
        this.xM = 10;
        this.MS = player.getPlayerId();
        this.Ln = player.getDisplayName();
        this.Mr = player.getIconImageUri();
        this.MC = player.getIconImageUrl();
        this.Ms = player.getHiResImageUri();
        this.MD = player.getHiResImageUrl();
        this.MT = player.getRetrievedTimestamp();
        this.MU = player.gS();
        this.MV = player.getLastPlayedWithTimestamp();
        this.HY = player.getTitle();
        this.MY = player.gT();
        MostRecentGameInfo mostRecentGameInfo = player.gU();
        this.MW = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.MX = player.getLevelInfo();
        gx.c(this.MS);
        gx.c(this.Ln);
        gx.A(this.MT > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean hasAllPublic) {
        this.xM = versionCode;
        this.MS = playerId;
        this.Ln = displayName;
        this.Mr = iconImageUri;
        this.MC = iconImageUrl;
        this.Ms = hiResImageUri;
        this.MD = hiResImageUrl;
        this.MT = retrievedTimestamp;
        this.MU = isInCircles;
        this.MV = lastPlayedWithTimestamp;
        this.HY = title;
        this.MY = hasAllPublic;
        this.MW = mostRecentGameInfo;
        this.MX = playerLevelInfo;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public String getPlayerId() {
        return this.MS;
    }

    @Override
    public String getDisplayName() {
        return this.Ln;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        ik.b(this.Ln, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mr;
    }

    @Override
    public String getIconImageUrl() {
        return this.MC;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.Ms;
    }

    @Override
    public String getHiResImageUrl() {
        return this.MD;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.MT;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.MV;
    }

    @Override
    public int gS() {
        return this.MU;
    }

    @Override
    public boolean gT() {
        return this.MY;
    }

    @Override
    public String getTitle() {
        return this.HY;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        ik.b(this.HY, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.MX;
    }

    @Override
    public MostRecentGameInfo gU() {
        return this.MW;
    }

    @Override
    public Player freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.a(this);
    }

    static int a(Player player) {
        return hk.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return hk.equal(player2.getPlayerId(), player.getPlayerId()) && hk.equal(player2.getDisplayName(), player.getDisplayName()) && hk.equal(player2.getIconImageUri(), player.getIconImageUri()) && hk.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && hk.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp()) && hk.equal(player2.getTitle(), player.getTitle()) && hk.equal(player2.getLevelInfo(), player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    static String b(Player player) {
        return hk.e(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("IconImageUrl", player.getIconImageUrl()).a("HiResImageUri", player.getHiResImageUri()).a("HiResImageUrl", player.getHiResImageUrl()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).a("Title", player.getTitle()).a("LevelInfo", player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fr()) {
            PlayerEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.MS);
            dest.writeString(this.Ln);
            dest.writeString(this.Mr == null ? null : this.Mr.toString());
            dest.writeString(this.Ms == null ? null : this.Ms.toString());
            dest.writeLong(this.MT);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity be(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.fq());
            if (bl2 || PlayerEntity.aA(PlayerEntity.class.getCanonicalName())) {
                return super.be(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l2 = parcel.readLong();
            int n2 = -1;
            long l3 = -1L;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl3 = true;
            return new PlayerEntity(10, string2, string3, uri, uri2, l2, n2, l3, string6, string7, string8, mostRecentGameInfoEntity, playerLevelInfo, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.be(x0);
        }
    }
}

