/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AclsImpl;
import com.google.android.gms.games.internal.api.EventsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.QuestsImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.SnapshotsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.hm;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    static final Api.c<GamesClientImpl> yH = new Api.c();
    private static final Api.b<GamesClientImpl, GamesOptions> yI = new Api.b<GamesClientImpl, GamesOptions>(){

        @Override
        public GamesClientImpl a(Context context, Looper looper, gy gy2, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, gy2.fn(), gy2.fj(), connectionCallbacks, onConnectionFailedListener, gy2.fm(), gy2.fk(), gy2.fo(), gamesOptions.MM, gamesOptions.MN, gamesOptions.MO, gamesOptions.MP, gamesOptions.MQ, gamesOptions.MR);
        }

        @Override
        public int getPriority() {
            return 1;
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api<GamesOptions>(yI, yH, SCOPE_GAMES);
    public static final Scope MI = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> MJ = new Api<GamesOptions>(yI, yH, MI);
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final Events Events = new EventsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer MK = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Quests Quests = new QuestsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Snapshots Snapshots = new SnapshotsImpl();
    public static final Acls ML = new AclsImpl();

    private Games() {
    }

    public static GamesClientImpl c(GoogleApiClient googleApiClient) {
        hm.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        hm.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        return Games.d(googleApiClient);
    }

    public static GamesClientImpl d(GoogleApiClient googleApiClient) {
        GamesClientImpl gamesClientImpl = googleApiClient.a(yH);
        hm.a(gamesClientImpl != null, "GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return gamesClientImpl;
    }

    public static void setGravityForPopups(GoogleApiClient apiClient, int gravity) {
        Games.c(apiClient).cg(gravity);
    }

    public static void setViewForPopups(GoogleApiClient apiClient, View gamesContentView) {
        hm.f(gamesContentView);
        Games.c(apiClient).f(gamesContentView);
    }

    public static String getCurrentAccountName(GoogleApiClient apiClient) {
        return Games.c(apiClient).gZ();
    }

    public static String getAppId(GoogleApiClient apiClient) {
        return Games.c(apiClient).ho();
    }

    public static Intent getSettingsIntent(GoogleApiClient apiClient) {
        return Games.c(apiClient).hm();
    }

    public static PendingResult<Status> signOut(GoogleApiClient apiClient) {
        return apiClient.b(new SignOutImpl(){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b(this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient apiClient) {
        return Games.c(apiClient).hn();
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl() {
        }

        public Status d(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.d(status);
        }
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends a.b<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl() {
            super(yH);
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        final boolean MM;
        final boolean MN;
        final int MO;
        final boolean MP;
        final int MQ;
        final String MR;

        private GamesOptions() {
            this.MM = false;
            this.MN = true;
            this.MO = 17;
            this.MP = false;
            this.MQ = 4368;
            this.MR = null;
        }

        private GamesOptions(Builder builder) {
            this.MM = builder.MM;
            this.MN = builder.MN;
            this.MO = builder.MO;
            this.MP = builder.MP;
            this.MQ = builder.MQ;
            this.MR = builder.MR;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean MM = false;
            boolean MN = true;
            int MO = 17;
            boolean MP = false;
            int MQ = 4368;
            String MR = null;

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup) {
                this.MN = showConnectingPopup;
                this.MO = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
                this.MN = showConnectingPopup;
                this.MO = gravity;
                return this;
            }

            public Builder setSdkVariant(int variant) {
                this.MQ = variant;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

