/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.ik;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int xM;
    private final String zP;
    private final String Ln;
    private final String Mn;
    private final String Mo;
    private final String Mp;
    private final String Mq;
    private final Uri Mr;
    private final Uri Ms;
    private final Uri Mt;
    private final boolean Mu;
    private final boolean Mv;
    private final String Mw;
    private final int Mx;
    private final int My;
    private final int Mz;
    private final boolean MA;
    private final boolean MB;
    private final String MC;
    private final String MD;
    private final String ME;
    private final boolean MF;
    private final boolean MG;
    private final boolean MH;

    public GameEntity(Game game) {
        this.xM = 4;
        this.zP = game.getApplicationId();
        this.Mn = game.getPrimaryCategory();
        this.Mo = game.getSecondaryCategory();
        this.Mp = game.getDescription();
        this.Mq = game.getDeveloperName();
        this.Ln = game.getDisplayName();
        this.Mr = game.getIconImageUri();
        this.MC = game.getIconImageUrl();
        this.Ms = game.getHiResImageUri();
        this.MD = game.getHiResImageUrl();
        this.Mt = game.getFeaturedImageUri();
        this.ME = game.getFeaturedImageUrl();
        this.Mu = game.gM();
        this.Mv = game.gO();
        this.Mw = game.gP();
        this.Mx = game.gQ();
        this.My = game.getAchievementTotalCount();
        this.Mz = game.getLeaderboardCount();
        this.MA = game.isRealTimeMultiplayerEnabled();
        this.MB = game.isTurnBasedMultiplayerEnabled();
        this.MF = game.isMuted();
        this.MG = game.gN();
        this.MH = game.areSnapshotsEnabled();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled) {
        this.xM = versionCode;
        this.zP = applicationId;
        this.Ln = displayName;
        this.Mn = primaryCategory;
        this.Mo = secondaryCategory;
        this.Mp = description;
        this.Mq = developerName;
        this.Mr = iconImageUri;
        this.MC = iconImageUrl;
        this.Ms = hiResImageUri;
        this.MD = hiResImageUrl;
        this.Mt = featuredImageUri;
        this.ME = featuredImageUrl;
        this.Mu = playEnabledGame;
        this.Mv = instanceInstalled;
        this.Mw = instancePackageName;
        this.Mx = gameplayAclStatus;
        this.My = achievementTotalCount;
        this.Mz = leaderboardCount;
        this.MA = realTimeEnabled;
        this.MB = turnBasedEnabled;
        this.MF = muted;
        this.MG = identitySharingConfirmed;
        this.MH = snapshotsEnabled;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public String getApplicationId() {
        return this.zP;
    }

    @Override
    public String getDisplayName() {
        return this.Ln;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        ik.b(this.Ln, dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.Mn;
    }

    @Override
    public String getSecondaryCategory() {
        return this.Mo;
    }

    @Override
    public String getDescription() {
        return this.Mp;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        ik.b(this.Mp, dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.Mq;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        ik.b(this.Mq, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mr;
    }

    @Override
    public String getIconImageUrl() {
        return this.MC;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.Ms;
    }

    @Override
    public String getHiResImageUrl() {
        return this.MD;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.Mt;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.ME;
    }

    @Override
    public boolean isMuted() {
        return this.MF;
    }

    @Override
    public boolean gN() {
        return this.MG;
    }

    @Override
    public boolean gM() {
        return this.Mu;
    }

    @Override
    public boolean gO() {
        return this.Mv;
    }

    @Override
    public String gP() {
        return this.Mw;
    }

    @Override
    public int gQ() {
        return this.Mx;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.My;
    }

    @Override
    public int getLeaderboardCount() {
        return this.Mz;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.MA;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.MB;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.MH;
    }

    @Override
    public Game freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return hk.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.gM(), game.gO(), game.gP(), game.gQ(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.gN(), game.areSnapshotsEnabled());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return hk.equal(game2.getApplicationId(), game.getApplicationId()) && hk.equal(game2.getDisplayName(), game.getDisplayName()) && hk.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && hk.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && hk.equal(game2.getDescription(), game.getDescription()) && hk.equal(game2.getDeveloperName(), game.getDeveloperName()) && hk.equal(game2.getIconImageUri(), game.getIconImageUri()) && hk.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && hk.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && hk.equal(game2.gM(), game.gM()) && hk.equal(game2.gO(), game.gO()) && hk.equal(game2.gP(), game.gP()) && hk.equal(game2.gQ(), game.gQ()) && hk.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && hk.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && hk.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && hk.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled() && hk.equal(game2.isMuted(), game.isMuted()) && hk.equal(game2.gN(), game.gN())) && hk.equal(game2.areSnapshotsEnabled(), game.areSnapshotsEnabled());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return hk.e(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("IconImageUrl", game.getIconImageUrl()).a("HiResImageUri", game.getHiResImageUri()).a("HiResImageUrl", game.getHiResImageUrl()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("FeaturedImageUrl", game.getFeaturedImageUrl()).a("PlayEnabledGame", game.gM()).a("InstanceInstalled", game.gO()).a("InstancePackageName", game.gP()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).a("AreSnapshotsEnabled", game.areSnapshotsEnabled()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fr()) {
            GameEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.zP);
            dest.writeString(this.Ln);
            dest.writeString(this.Mn);
            dest.writeString(this.Mo);
            dest.writeString(this.Mp);
            dest.writeString(this.Mq);
            dest.writeString(this.Mr == null ? null : this.Mr.toString());
            dest.writeString(this.Ms == null ? null : this.Ms.toString());
            dest.writeString(this.Mt == null ? null : this.Mt.toString());
            dest.writeInt(this.Mu ? 1 : 0);
            dest.writeInt(this.Mv ? 1 : 0);
            dest.writeString(this.Mw);
            dest.writeInt(this.Mx);
            dest.writeInt(this.My);
            dest.writeInt(this.Mz);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity bd(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.fq());
            if (bl2 || GameEntity.aA(GameEntity.class.getCanonicalName())) {
                return super.bd(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            boolean bl5 = false;
            boolean bl6 = false;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            return new GameEntity(4, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl3, bl4, string11, n2, n3, n4, bl5, bl6, string12, string13, string14, bl7, bl8, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bd(x0);
        }
    }
}

