/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.c;
import com.google.android.gms.internal.hg;
import com.google.android.gms.internal.hm;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class a {
    static void a(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"GoogleApi", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class c<R extends Result>
    extends Handler {
        public c() {
            this(Looper.getMainLooper());
        }

        public c(Looper looper) {
            super(looper);
        }

        public void a(ResultCallback<R> resultCallback, R r2) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r2)));
        }

        public void a(a<R> a2, long l2) {
            this.sendMessageDelayed(this.obtainMessage(2, a2), l2);
        }

        public void eH() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.b((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    a a2 = (a)msg.obj;
                    a2.eF();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void b(ResultCallback<R> resultCallback, R r2) {
            try {
                resultCallback.onResult(r2);
            }
            catch (RuntimeException runtimeException) {
                a.a(r2);
                throw runtimeException;
            }
        }
    }

    public static abstract class a<R extends Result>
    implements PendingResult<R>,
    d<R> {
        private final Object Dp = new Object();
        private c<R> Dq;
        private final CountDownLatch kK = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> Dr = new ArrayList();
        private ResultCallback<R> Ds;
        private volatile R Dt;
        private volatile boolean Du;
        private boolean Dv;
        private boolean Dw;
        private hg Dx;

        a() {
        }

        public a(Looper looper) {
            this.Dq = new c(looper);
        }

        public a(c<R> c2) {
            this.Dq = c2;
        }

        protected abstract R c(Status var1);

        public final boolean isReady() {
            return this.kK.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R eC() {
            Object object = this.Dp;
            synchronized (object) {
                hm.a(!this.Du, "Result has already been consumed.");
                hm.a(this.isReady(), "Result is not ready.");
                R r2 = this.Dt;
                this.eD();
                return r2;
            }
        }

        @Override
        public final R await() {
            hm.a(Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
            hm.a(!this.Du, "Result has already been consumed");
            try {
                this.kK.await();
            }
            catch (InterruptedException interruptedException) {
                this.eE();
            }
            hm.a(this.isReady(), "Result is not ready.");
            return this.eC();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            hm.a(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread when time is greater than zero.");
            hm.a(!this.Du, "Result has already been consumed.");
            try {
                boolean bl2 = this.kK.await(time, units);
                if (!bl2) {
                    this.eF();
                }
            }
            catch (InterruptedException interruptedException) {
                this.eE();
            }
            hm.a(this.isReady(), "Result is not ready.");
            return this.eC();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            hm.a(!this.Du, "Result has already been consumed.");
            Object object = this.Dp;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.Dq.a(callback, this.eC());
                } else {
                    this.Ds = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            hm.a(!this.Du, "Result has already been consumed.");
            Object object = this.Dp;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.Dq.a(callback, this.eC());
                } else {
                    this.Ds = callback;
                    this.Dq.a(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            hm.a(!this.Du, "Result has already been consumed.");
            Object object = this.Dp;
            synchronized (object) {
                if (this.isReady()) {
                    a2.n(this.Dt.getStatus());
                } else {
                    this.Dr.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void a(hg hg2) {
            Object object = this.Dp;
            synchronized (object) {
                this.Dx = hg2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.Dp;
            synchronized (object) {
                if (this.Dv || this.Du) {
                    return;
                }
                if (this.Dx != null) {
                    try {
                        this.Dx.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                a.a(this.Dt);
                this.Ds = null;
                this.Dv = true;
                this.c(this.c(Status.Er));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.Dp;
            synchronized (object) {
                return this.Dv;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void b(R r2) {
            Object object = this.Dp;
            synchronized (object) {
                if (this.Dw || this.Dv) {
                    a.a(r2);
                    return;
                }
                hm.a(!this.isReady(), "Results have already been set");
                hm.a(!this.Du, "Result has already been consumed");
                this.c(r2);
            }
        }

        protected void eD() {
            this.Du = true;
            this.Dt = null;
            this.Ds = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eE() {
            Object object = this.Dp;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.Eo));
                    this.Dw = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eF() {
            Object object = this.Dp;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.Eq));
                    this.Dw = true;
                }
            }
        }

        private void c(R r2) {
            this.Dt = r2;
            this.Dx = null;
            this.kK.countDown();
            Status status = this.Dt.getStatus();
            if (this.Ds != null) {
                this.Dq.eH();
                if (!this.Dv) {
                    this.Dq.a(this.Ds, this.eC());
                }
            }
            for (PendingResult.a a2 : this.Dr) {
                a2.n(status);
            }
            this.Dr.clear();
        }

        @Override
        protected void a(c<R> c2) {
            this.Dq = c2;
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.b((Result)object);
        }
    }

    public static abstract class b<R extends Result, A extends Api.a>
    extends a<R>
    implements c.c<A> {
        private final Api.c<A> Dn;
        private c.a Dy;

        protected b(Api.c<A> c2) {
            this.Dn = hm.f(c2);
        }

        @Override
        public final Api.c<A> eB() {
            return this.Dn;
        }

        @Override
        public final void b(A a2) throws DeadObjectException {
            this.a((A)((Object)new c(a2.getLooper())));
            try {
                this.a(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void m(Status status) {
            hm.b(!status.isSuccess(), (Object)"Failed result must not be success");
            this.b((A)this.c(status));
        }

        @Override
        public void a(c.a a2) {
            this.Dy = a2;
        }

        @Override
        public int eG() {
            return 0;
        }

        @Override
        protected abstract void a(A var1) throws RemoteException;

        @Override
        protected void eD() {
            super.eD();
            if (this.Dy != null) {
                this.Dy.b(this);
                this.Dy = null;
            }
        }

        @Override
        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.m(status);
        }
    }

    public static interface d<R> {
        public void a(R var1);
    }
}

