/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.api.c;
import com.google.android.gms.common.api.d;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.hm;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.a, T extends a.b<? extends Result, A>> T a(T var1);

    public <A extends Api.a, T extends a.b<? extends Result, A>> T b(T var1);

    public <C extends Api.a> C a(Api.c<C> var1);

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public void stopAutoManage();

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public static final class Builder {
        private String yQ;
        private final Set<String> DH = new HashSet<String>();
        private int DI;
        private View DJ;
        private String DK;
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> DL = new HashMap();
        private FragmentActivity DM;
        private OnConnectionFailedListener DN;
        private Looper DF;
        private final Set<ConnectionCallbacks> DO = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> DP = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.DF = context.getMainLooper();
            this.DK = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            hm.b(connectedListener, (Object)"Must provide a connected listener");
            this.DO.add(connectedListener);
            hm.b(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.DP.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            hm.b(handler, (Object)"Handler must not be null");
            this.DF = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.DO.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.DP.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.DJ = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.DH.add(scope.eP());
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.DL.put(api, null);
            List<Scope> list = api.eA();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.DH.add(list.get(i2).eP());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            hm.b(options, (Object)"Null options are not permitted for this Api");
            this.DL.put(api, options);
            List<Scope> list = api.eA();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.DH.add(list.get(i2).eP());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.yQ = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.DI = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            this.DM = hm.b(fragmentActivity, (Object)"Null activity is not permitted.");
            this.DN = unresolvedConnectionFailedListener;
            return this;
        }

        public gy eI() {
            return new gy(this.yQ, this.DH, this.DI, this.DJ, this.DK);
        }

        public GoogleApiClient build() {
            hm.b(!this.DL.isEmpty(), (Object)"must call addApi() to add at least one API");
            d d2 = null;
            if (this.DM != null) {
                d2 = this.eJ();
            }
            c c2 = new c(this.mContext, this.DF, this.eI(), this.DL, d2, this.DO, this.DP);
            if (d2 != null) {
                d2.a(c2, this.DN);
            }
            return c2;
        }

        private d eJ() {
            FragmentManager fragmentManager = this.DM.getSupportFragmentManager();
            List list = fragmentManager.getFragments();
            if (list != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    if (!(fragment instanceof d) || !fragment.isAdded() || ((d)fragment).isInitialized()) continue;
                    return (d)fragment;
                }
            }
            d d2 = new d();
            fragmentManager.beginTransaction().add((Fragment)d2, null).commit();
            return d2;
        }
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
        @Override
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

