/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.in;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    private final String At;
    private int Au;
    private String Av;
    private MediaMetadata Aw;
    private long Ax;
    private List<MediaTrack> Ay;
    private TextTrackStyle Az;
    private JSONObject AA;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.At = contentId;
        this.Au = -1;
    }

    MediaInfo(JSONObject json) throws JSONException {
        int n2;
        JSONObject jSONObject;
        this.At = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.Au = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.Av = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n2 = jSONObject.getInt("metadataType");
            this.Aw = new MediaMetadata(n2);
            this.Aw.b(jSONObject);
        }
        this.Ax = gi.b(json.optDouble("duration", 0.0));
        if (json.has("tracks")) {
            this.Ay = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n2 = 0; n2 < jSONObject.length(); ++n2) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n2);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.Ay.add(mediaTrack);
            }
        } else {
            this.Ay = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.b(jSONObject);
            this.Az = textTrackStyle;
        } else {
            this.Az = null;
        }
        this.AA = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.At;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.Au = streamType;
    }

    public int getStreamType() {
        return this.Au;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.Av = contentType;
    }

    public String getContentType() {
        return this.Av;
    }

    void a(MediaMetadata mediaMetadata) {
        this.Aw = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.Aw;
    }

    void m(long l2) throws IllegalArgumentException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Stream duration cannot be negative");
        }
        this.Ax = l2;
    }

    public long getStreamDuration() {
        return this.Ax;
    }

    void b(List<MediaTrack> list) {
        this.Ay = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.Ay;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.Az = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.Az;
    }

    void setCustomData(JSONObject customData) {
        this.AA = customData;
    }

    public JSONObject getCustomData() {
        return this.AA;
    }

    void dY() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.At)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.Av)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.Au == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject dZ() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.At);
            switch (this.Au) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.Av != null) {
                jSONObject.put("contentType", (Object)this.Av);
            }
            if (this.Aw != null) {
                jSONObject.put("metadata", (Object)this.Aw.dZ());
            }
            jSONObject.put("duration", gi.o(this.Ax));
            if (this.Ay != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.Ay) {
                    jSONArray.put((Object)mediaTrack.dZ());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.Az != null) {
                jSONObject.put("textTrackStyle", (Object)this.Az.dZ());
            }
            if (this.AA != null) {
                jSONObject.put("customData", (Object)this.AA);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.AA == null != (mediaInfo.AA == null)) {
            return false;
        }
        if (this.AA != null && mediaInfo.AA != null && !in.d(this.AA, mediaInfo.AA)) {
            return false;
        }
        return gi.a(this.At, mediaInfo.At) && this.Au == mediaInfo.Au && gi.a(this.Av, mediaInfo.Av) && gi.a(this.Aw, mediaInfo.Aw) && this.Ax == mediaInfo.Ax;
    }

    public int hashCode() {
        return hk.hashCode(this.At, this.Au, this.Av, this.Aw, this.Ax, String.valueOf(this.AA));
    }

    public static class Builder {
        private final MediaInfo AB;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.AB = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.AB.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.AB.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.AB.a(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.AB.m(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.AB.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.AB.b(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.AB.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.AB.dY();
            return this.AB;
        }
    }
}

