/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.gh;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.hm;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    static final Api.c<gh> yH = new Api.c();
    private static final Api.b<gh, CastOptions> yI = new Api.b<gh, CastOptions>(){

        @Override
        public gh a(Context context, Looper looper, gy gy2, CastOptions castOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            hm.b(castOptions, (Object)"Setting the API options is required.");
            return new gh(context, looper, castOptions.Aa, castOptions.Ac, castOptions.Ab, connectionCallbacks, onConnectionFailedListener);
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };
    public static final Api<CastOptions> API = new Api<CastOptions>(yI, yH, new Scope[0]);
    public static final CastApi CastApi = new CastApi.a();

    private Cast() {
    }

    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        @Deprecated
        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, LaunchOptions var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        public static final class a
        implements CastApi {
            @Override
            public void requestStatus(GoogleApiClient client) throws IOException, IllegalStateException {
                try {
                    client.a(yH).eg();
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public PendingResult<Status> sendMessage(GoogleApiClient client, final String namespace, final String message) {
                return client.b(new b(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        try {
                            gh2.a(namespace, message, this);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.N(2001);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId) {
                return client.b(new c(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        try {
                            gh2.a(applicationId, false, (a.d<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId, final LaunchOptions options) {
                return client.b(new c(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        try {
                            gh2.a(applicationId, options, (a.d<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            @Deprecated
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, String applicationId, boolean relaunchIfRunning) {
                LaunchOptions launchOptions = new LaunchOptions.Builder().setRelaunchIfRunning(relaunchIfRunning).build();
                return this.launchApplication(client, applicationId, launchOptions);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, final String applicationId, final String sessionId) {
                return client.b(new c(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        try {
                            gh2.b(applicationId, sessionId, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, final String applicationId) {
                return client.b(new c(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        try {
                            gh2.b(applicationId, null, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client) {
                return client.b(new c(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        try {
                            gh2.b(null, null, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> leaveApplication(GoogleApiClient client) {
                return client.b(new b(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        try {
                            gh2.d(this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client) {
                return client.b(new b(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        try {
                            gh2.a("", this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client, final String sessionId) {
                return client.b(new b(){

                    @Override
                    protected void a(gh gh2) throws RemoteException {
                        if (TextUtils.isEmpty((CharSequence)sessionId)) {
                            this.c(2001, "IllegalArgument: sessionId cannot be null or empty");
                            return;
                        }
                        try {
                            gh2.a(sessionId, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.N(2001);
                        }
                    }
                });
            }

            @Override
            public void setVolume(GoogleApiClient client, double volume) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    client.a(yH).a(volume);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public double getVolume(GoogleApiClient client) throws IllegalStateException {
                return client.a(yH).eh();
            }

            @Override
            public void setMute(GoogleApiClient client, boolean mute) throws IOException, IllegalStateException {
                try {
                    client.a(yH).y(mute);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public boolean isMute(GoogleApiClient client) throws IllegalStateException {
                return client.a(yH).isMute();
            }

            @Override
            public ApplicationMetadata getApplicationMetadata(GoogleApiClient client) throws IllegalStateException {
                return client.a(yH).getApplicationMetadata();
            }

            @Override
            public String getApplicationStatus(GoogleApiClient client) throws IllegalStateException {
                return client.a(yH).getApplicationStatus();
            }

            @Override
            public void setMessageReceivedCallbacks(GoogleApiClient client, String namespace, MessageReceivedCallback callbacks) throws IOException, IllegalStateException {
                try {
                    client.a(yH).a(namespace, callbacks);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public void removeMessageReceivedCallbacks(GoogleApiClient client, String namespace) throws IOException, IllegalArgumentException {
                try {
                    client.a(yH).aj(namespace);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    private static abstract class b
    extends a<Status> {
        private b() {
        }

        public Status d(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.d(status);
        }
    }

    private static abstract class c
    extends a<ApplicationConnectionResult> {
        private c() {
        }

        public ApplicationConnectionResult j(final Status status) {
            return new ApplicationConnectionResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public boolean getWasLaunched() {
                    return false;
                }

                @Override
                public String getSessionId() {
                    return null;
                }

                @Override
                public String getApplicationStatus() {
                    return null;
                }

                @Override
                public ApplicationMetadata getApplicationMetadata() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.j(status);
        }
    }

    protected static abstract class a<R extends Result>
    extends a.b<R, gh> {
        public a() {
            super(yH);
        }

        public void N(int n2) {
            this.b(this.c(new Status(n2)));
        }

        public void c(int n2, String string2) {
            this.b(this.c(new Status(n2, string2, null)));
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice Aa;
        final Listener Ab;
        private final int Ac;

        private CastOptions(Builder builder) {
            this.Aa = builder.Ad;
            this.Ab = builder.Ae;
            this.Ac = builder.Af;
        }

        public static Builder builder(CastDevice castDevice, Listener castListener) {
            return new Builder(castDevice, castListener);
        }

        public static final class Builder {
            CastDevice Ad;
            Listener Ae;
            private int Af;

            private Builder(CastDevice castDevice, Listener castListener) {
                hm.b(castDevice, (Object)"CastDevice parameter cannot be null");
                hm.b(castListener, (Object)"CastListener parameter cannot be null");
                this.Ad = castDevice;
                this.Ae = castListener;
                this.Af = 0;
            }

            public Builder setVerboseLoggingEnabled(boolean enabled) {
                this.Af = enabled ? (this.Af |= 1) : (this.Af &= 0xFFFFFFFE);
                return this;
            }

            public CastOptions build() {
                return new CastOptions(this);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationDisconnected(int statusCode) {
        }

        public void O(int n2) {
        }

        public void onVolumeChanged() {
        }
    }
}

