/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ad;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.u;
import com.google.android.gms.analytics.z;
import com.google.android.gms.internal.hm;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker {
    private final TrackerHandler xe;
    private Context mContext;
    private final Map<String, String> xf = new HashMap<String, String>();
    private ad xg;
    private final h xh;
    private final ae xi;
    private final g xj;
    private boolean xk;
    private a xl;
    private aj xm;
    private ExceptionReporter xn;

    Tracker(String trackingId, TrackerHandler handler, Context context) {
        this(trackingId, handler, h.cv(), ae.dv(), g.cu(), new z("tracking"), context);
    }

    Tracker(String trackingId, TrackerHandler handler, h clientIdDefaultProvider, ae screenResolutionDefaultProvider, g appFieldsDefaultProvider, ad rateLimiter, Context context) {
        this.xe = handler;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        if (trackingId != null) {
            this.xf.put("&tid", trackingId);
        }
        this.xf.put("useSecure", "1");
        this.xh = clientIdDefaultProvider;
        this.xi = screenResolutionDefaultProvider;
        this.xj = appFieldsDefaultProvider;
        this.xf.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.xg = rateLimiter;
        this.xl = new a();
        this.enableAdvertisingIdCollection(false);
    }

    void a(aj aj2) {
        String string2;
        aa.C("Loading Tracker config values.");
        this.xm = aj2;
        if (this.xm.dE()) {
            string2 = this.xm.dF();
            this.set("&tid", string2);
            aa.C("[Tracker] trackingId loaded: " + string2);
        }
        if (this.xm.dG()) {
            string2 = Double.toString(this.xm.dH());
            this.set("&sf", string2);
            aa.C("[Tracker] sample frequency loaded: " + string2);
        }
        if (this.xm.dI()) {
            this.setSessionTimeout(this.xm.getSessionTimeout());
            aa.C("[Tracker] session timeout loaded: " + this.dy());
        }
        if (this.xm.dJ()) {
            this.enableAutoActivityTracking(this.xm.dK());
            aa.C("[Tracker] auto activity tracking loaded: " + this.dz());
        }
        if (this.xm.dL()) {
            if (this.xm.dM()) {
                this.set("&aip", "1");
                aa.C("[Tracker] anonymize ip loaded: true");
            }
            aa.C("[Tracker] anonymize ip loaded: false");
        }
        this.enableExceptionReporting(this.xm.dN());
    }

    public void enableExceptionReporting(boolean enabled) {
        if (this.xk == enabled) {
            return;
        }
        this.xk = enabled;
        if (enabled) {
            this.xn = new ExceptionReporter(this, Thread.getDefaultUncaughtExceptionHandler(), this.mContext);
            Thread.setDefaultUncaughtExceptionHandler(this.xn);
            aa.C("Uncaught exceptions will be reported to Google Analytics.");
        } else {
            if (this.xn != null) {
                Thread.setDefaultUncaughtExceptionHandler(this.xn.cD());
            } else {
                Thread.setDefaultUncaughtExceptionHandler(null);
            }
            aa.C("Uncaught exceptions will not be reported to Google Analytics.");
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.xl.setSessionTimeout(sessionTimeout * 1000L);
    }

    long dy() {
        return this.xl.dy();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.xl.enableAutoActivityTracking(enabled);
    }

    boolean dz() {
        return this.xl.dz();
    }

    public void send(Map<String, String> params) {
        String string2;
        u.cU().a(u.a.vh);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.xf);
        if (params != null) {
            hashMap.putAll(params);
        }
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            aa.D(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = (String)hashMap.get("&t")))) {
            aa.D(String.format("Missing hit type (%s) parameter.", "&t"));
            string2 = "";
        }
        if (this.xl.dA()) {
            hashMap.put("&sc", "start");
        }
        if ("screenview".equals(string2 = string2.toLowerCase()) || "pageview".equals(string2) || "appview".equals(string2) || TextUtils.isEmpty((CharSequence)string2)) {
            int n2 = Integer.parseInt(this.xf.get("&a"));
            n2 = ++n2 >= Integer.MAX_VALUE ? 1 : n2;
            this.xf.put("&a", Integer.toString(n2));
        }
        if (!(string2.equals("transaction") || string2.equals("item") || this.xg.do())) {
            aa.D("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.xe.p(hashMap);
        }
    }

    public String get(String key) {
        u.cU().a(u.a.vf);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.xf.containsKey(key)) {
            return this.xf.get(key);
        }
        if (key.equals("&ul")) {
            return ak.a(Locale.getDefault());
        }
        if (this.xh != null && this.xh.J(key)) {
            return this.xh.getValue(key);
        }
        if (this.xi != null && this.xi.J(key)) {
            return this.xi.getValue(key);
        }
        if (this.xj != null && this.xj.J(key)) {
            return this.xj.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        hm.b(key, (Object)"Key should be non-null");
        u.cU().a(u.a.vg);
        this.xf.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toHexString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", ak.v(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            aa.D("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", ak.v(anonymize));
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.xf.put("&ate", null);
            this.xf.put("&adid", null);
        } else {
            if (this.xf.containsKey("&ate")) {
                this.xf.remove("&ate");
            }
            if (this.xf.containsKey("&adid")) {
                this.xf.remove("&adid");
            }
        }
    }

    private class a
    implements GoogleAnalytics.a {
        private boolean xo = false;
        private int xp = 0;
        private long xq = -1L;
        private boolean xr = false;
        private long xs;
        private i uu;

        public a() {
            this.uu = new i(){

                @Override
                public long currentTimeMillis() {
                    return System.currentTimeMillis();
                }
            };
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.xq = sessionTimeout;
            this.dB();
        }

        public long dy() {
            return this.xq;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.xo = enabled;
            this.dB();
        }

        public boolean dz() {
            return this.xo;
        }

        public boolean dA() {
            boolean bl2 = this.xr;
            this.xr = false;
            return bl2;
        }

        private void dB() {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.di();
            if (googleAnalytics == null) {
                aa.A("GoogleAnalytics isn't initialized for the Tracker!");
                return;
            }
            if (this.xq >= 0L || this.xo) {
                googleAnalytics.a(Tracker.this.xl);
            } else {
                googleAnalytics.b(Tracker.this.xl);
            }
        }

        @Override
        public void h(Activity activity) {
            u.cU().a(u.a.we);
            if (this.xp == 0 && this.dC()) {
                this.xr = true;
            }
            ++this.xp;
            if (this.xo) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                u.cU().u(true);
                Tracker.this.set("&cd", Tracker.this.xm != null ? Tracker.this.xm.j(activity) : activity.getClass().getCanonicalName());
                Tracker.this.send(hashMap);
                u.cU().u(false);
            }
        }

        @Override
        public void i(Activity activity) {
            u.cU().a(u.a.wf);
            --this.xp;
            this.xp = Math.max(0, this.xp);
            if (this.xp == 0) {
                this.xs = this.uu.currentTimeMillis();
            }
        }

        boolean dC() {
            return this.uu.currentTimeMillis() >= this.xs + Math.max(1000L, this.xq);
        }
    }
}

