/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.internal.at;
import com.google.android.gms.internal.hm;
import java.util.Date;
import java.util.Set;

public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final String DEVICE_ID_EMULATOR = at.DEVICE_ID_EMULATOR;
    private final at ks;

    private PublisherAdRequest(Builder builder) {
        this.ks = new at(builder.kt);
    }

    public Date getBirthday() {
        return this.ks.getBirthday();
    }

    public String getContentUrl() {
        return this.ks.getContentUrl();
    }

    public int getGender() {
        return this.ks.getGender();
    }

    public Set<String> getKeywords() {
        return this.ks.getKeywords();
    }

    public Location getLocation() {
        return this.ks.getLocation();
    }

    public boolean getManualImpressionsEnabled() {
        return this.ks.getManualImpressionsEnabled();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> networkExtrasClass) {
        return this.ks.getNetworkExtras(networkExtrasClass);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> adapterClass) {
        return this.ks.getNetworkExtrasBundle(adapterClass);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> adapterClass) {
        return this.ks.getCustomEventExtrasBundle(adapterClass);
    }

    public String getPublisherProvidedId() {
        return this.ks.getPublisherProvidedId();
    }

    public boolean isTestDevice(Context context) {
        return this.ks.isTestDevice(context);
    }

    at T() {
        return this.ks;
    }

    public static final class Builder {
        private final at.a kt = new at.a();

        public Builder addKeyword(String keyword) {
            this.kt.g(keyword);
            return this;
        }

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.kt.a(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> adapterClass, Bundle networkExtras) {
            this.kt.a(adapterClass, networkExtras);
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> adapterClass, Bundle customEventExtras) {
            this.kt.b(adapterClass, customEventExtras);
            return this;
        }

        public Builder addTestDevice(String deviceId) {
            this.kt.h(deviceId);
            return this;
        }

        public PublisherAdRequest build() {
            return new PublisherAdRequest(this);
        }

        public Builder setBirthday(Date birthday) {
            this.kt.a(birthday);
            return this;
        }

        public Builder setContentUrl(String contentUrl) {
            hm.b(contentUrl, (Object)"Content URL must be non-null.");
            hm.b(contentUrl, (Object)"Content URL must be non-empty.");
            hm.b(contentUrl.length() <= 512, "Content URL must not exceed %d in length.  Provided length was %d.", 512, contentUrl.length());
            this.kt.i(contentUrl);
            return this;
        }

        public Builder setGender(int gender) {
            this.kt.e(gender);
            return this;
        }

        public Builder setLocation(Location location) {
            this.kt.a(location);
            return this;
        }

        public Builder setManualImpressionsEnabled(boolean manualImpressionsEnabled) {
            this.kt.g(manualImpressionsEnabled);
            return this;
        }

        public Builder setPublisherProvidedId(String publisherProvidedId) {
            this.kt.j(publisherProvidedId);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean tagForChildDirectedTreatment) {
            this.kt.h(tagForChildDirectedTreatment);
            return this;
        }
    }
}

