/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.q;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import com.google.android.gms.maps.model.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int ab;
    private final List<LatLng> hB;
    private final List<List<LatLng>> hC;
    private float gY = 10.0f;
    private int gZ = -16777216;
    private int ha = 0;
    private float hb = 0.0f;
    private boolean hc = true;
    private boolean hD = false;

    public PolygonOptions() {
        this.ab = 1;
        this.hB = new ArrayList<LatLng>();
        this.hC = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.ab = versionCode;
        this.hB = points;
        this.hC = holes;
        this.gY = strokeWidth;
        this.gZ = strokeColor;
        this.ha = fillColor;
        this.hb = zIndex;
        this.hc = visible;
        this.hD = geodesic;
    }

    int i() {
        return this.ab;
    }

    List br() {
        return this.hC;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (q.bn()) {
            g.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.hB.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.hB.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.hB.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.hC.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.gY = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.gZ = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.ha = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.hb = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.hc = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.hD = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.hB;
    }

    public List<List<LatLng>> getHoles() {
        return this.hC;
    }

    public float getStrokeWidth() {
        return this.gY;
    }

    public int getStrokeColor() {
        return this.gZ;
    }

    public int getFillColor() {
        return this.ha;
    }

    public float getZIndex() {
        return this.hb;
    }

    public boolean isVisible() {
        return this.hc;
    }

    public boolean isGeodesic() {
        return this.hD;
    }
}

