/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.internal.s;
import com.google.android.gms.maps.internal.q;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int ab;
    private BitmapDescriptor he;
    private LatLng hf;
    private float hg;
    private float hh;
    private LatLngBounds hi;
    private float gU;
    private float hb;
    private boolean hc = true;
    private float hj = 0.0f;
    private float hk = 0.5f;
    private float hl = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.ab = versionCode;
        this.he = new BitmapDescriptor(b.a.l(wrappedImage));
        this.hf = location;
        this.hg = width;
        this.hh = height;
        this.hi = bounds;
        this.gU = bearing;
        this.hb = zIndex;
        this.hc = visible;
        this.hj = transparency;
        this.hk = anchorU;
        this.hl = anchorV;
    }

    public GroundOverlayOptions() {
        this.ab = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (q.bn()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder bp() {
        return this.he.aW().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.he = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.hk = u2;
        this.hl = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        s.a(this.hi == null, "Position has already been set using positionFromBounds");
        s.b(location != null, (Object)"Location must be specified");
        s.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        s.a(this.hi == null, "Position has already been set using positionFromBounds");
        s.b(location != null, (Object)"Location must be specified");
        s.b(width >= 0.0f, (Object)"Width must be non-negative");
        s.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.hf = latLng;
        this.hg = f2;
        this.hh = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        s.a(this.hf == null, "Position has already been set using position: " + this.hf);
        this.hi = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.gU = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.hb = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.hc = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        s.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.hj = transparency;
        return this;
    }

    int i() {
        return this.ab;
    }

    public BitmapDescriptor getImage() {
        return this.he;
    }

    public LatLng getLocation() {
        return this.hf;
    }

    public float getWidth() {
        return this.hg;
    }

    public float getHeight() {
        return this.hh;
    }

    public LatLngBounds getBounds() {
        return this.hi;
    }

    public float getBearing() {
        return this.gU;
    }

    public float getZIndex() {
        return this.hb;
    }

    public float getTransparency() {
        return this.hj;
    }

    public float getAnchorU() {
        return this.hk;
    }

    public float getAnchorV() {
        return this.hl;
    }

    public boolean isVisible() {
        return this.hc;
    }
}

