/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.c;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.internal.s;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.o;
import com.google.android.gms.maps.internal.p;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class SupportMapFragment
extends Fragment {
    private final b gK = new b(this);
    private GoogleMap gz;

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions options) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    protected IMapFragmentDelegate bh() {
        this.gK.bi();
        if (this.gK.at() == null) {
            return null;
        }
        return ((a)this.gK.at()).bh();
    }

    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.bh();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.gz == null || this.gz.aY().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.gz = new GoogleMap(iGoogleMapDelegate);
        }
        return this.gz;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.gK.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.gK.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.gK.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.gK.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.gK.onCreateView(inflater, container, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.gK.onResume();
    }

    public void onPause() {
        this.gK.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.gK.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.gK.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.gK.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.gK.onSaveInstanceState(outState);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class b
    extends com.google.android.gms.dynamic.a<a> {
        private final Fragment gL;
        protected d<a> gC;
        private Activity bm;

        b(Fragment fragment) {
            this.gL = fragment;
        }

        @Override
        protected void a(d<a> d2) {
            this.gC = d2;
            this.bi();
        }

        public void bi() {
            if (this.bm != null && this.gC != null && this.at() == null) {
                try {
                    MapsInitializer.initialize((Context)this.bm);
                    IMapFragmentDelegate iMapFragmentDelegate = p.i((Context)this.bm).d(c.f(this.bm));
                    this.gC.a(new a(this.gL, iMapFragmentDelegate));
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.bm = activity;
            this.bi();
        }
    }

    static class a
    implements LifecycleDelegate {
        private final Fragment gL;
        private final IMapFragmentDelegate gB;

        public a(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.gB = s.d(iMapFragmentDelegate);
            this.gL = s.d(fragment);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.gB.onInflate(c.f(activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.gL.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    o.a(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.gB.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            com.google.android.gms.dynamic.b b2;
            try {
                b2 = this.gB.onCreateView(c.f(inflater), c.f(container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)c.a(b2);
        }

        public void onResume() {
            try {
                this.gB.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.gB.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            try {
                this.gB.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.gB.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.gB.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.gB.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate bh() {
            return this.gB;
        }
    }
}

