/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.q;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int ab;
    private Boolean go;
    private Boolean gp;
    private int gq = -1;
    private CameraPosition gr;
    private Boolean gs;
    private Boolean gt;
    private Boolean gu;
    private Boolean gv;
    private Boolean gw;
    private Boolean gx;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.ab = versionCode;
        this.go = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.gp = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.gq = mapType;
        this.gr = camera;
        this.gs = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.gt = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.gu = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.gv = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.gw = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.gx = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (q.bn()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int i() {
        return this.ab;
    }

    byte aZ() {
        return com.google.android.gms.maps.internal.a.b(this.go);
    }

    byte ba() {
        return com.google.android.gms.maps.internal.a.b(this.gp);
    }

    byte bb() {
        return com.google.android.gms.maps.internal.a.b(this.gs);
    }

    byte bc() {
        return com.google.android.gms.maps.internal.a.b(this.gt);
    }

    byte bd() {
        return com.google.android.gms.maps.internal.a.b(this.gu);
    }

    byte be() {
        return com.google.android.gms.maps.internal.a.b(this.gv);
    }

    byte bf() {
        return com.google.android.gms.maps.internal.a.b(this.gw);
    }

    byte bg() {
        return com.google.android.gms.maps.internal.a.b(this.gx);
    }

    public GoogleMapOptions() {
        this.ab = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.go = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.gp = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.gq = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.gr = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.gs = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.gt = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.gu = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.gv = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.gw = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.gx = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.go;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.gp;
    }

    public int getMapType() {
        return this.gq;
    }

    public CameraPosition getCamera() {
        return this.gr;
    }

    public Boolean getZoomControlsEnabled() {
        return this.gs;
    }

    public Boolean getCompassEnabled() {
        return this.gt;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.gu;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.gv;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.gw;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.gx;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

