/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.r;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int ab;
    int mPriority;
    long fB;
    long fC;
    boolean fD;
    long fw;
    int fE;
    float fF;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.ab = 1;
        this.mPriority = 102;
        this.fB = 3600000L;
        this.fC = 600000L;
        this.fD = false;
        this.fw = Long.MAX_VALUE;
        this.fE = Integer.MAX_VALUE;
        this.fF = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.M(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.c(millis);
        this.fB = millis;
        if (!this.fD) {
            this.fC = (long)((double)this.fB / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.fB;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.c(millis);
        this.fD = true;
        this.fC = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.fC;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.fw = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.fw < 0L) {
            this.fw = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.fw = millis;
        if (this.fw < 0L) {
            this.fw = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.fw;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.fE = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.fE;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.fF = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.fF;
    }

    private static void c(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void M(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.ab = versionCode;
        this.mPriority = priority;
        this.fB = interval;
        this.fC = fastestInterval;
        this.fD = explicitFastestInterval;
        this.fw = expireAt;
        this.fE = numUpdates;
        this.fF = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String N(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.N(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.fB + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.fC + "ms");
        if (this.fw != Long.MAX_VALUE) {
            long l2 = this.fw - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.fE != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.fE);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return r.hashCode(this.mPriority, this.fB, this.fC, this.fD, this.fw, this.fE, Float.valueOf(this.fF));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.fB == locationRequest.fB && this.fC == locationRequest.fC && this.fD == locationRequest.fD && this.fw == locationRequest.fw && this.fE == locationRequest.fE && this.fF == locationRequest.fF;
    }

    int i() {
        return this.ab;
    }
}

