/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.bi;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String fu = null;
        private int fv = 0;
        private long fw = Long.MIN_VALUE;
        private short fx = (short)-1;
        private double fy;
        private double fz;
        private float fA;

        public Builder setRequestId(String requestId) {
            this.fu = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.fv = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.fw = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.fx = 1;
            this.fy = latitude;
            this.fz = longitude;
            this.fA = radius;
            return this;
        }

        public Geofence build() {
            if (this.fu == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.fv == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if (this.fw == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.fx == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            return new bi(this.fu, this.fv, 1, this.fy, this.fz, this.fA, this.fw);
        }
    }
}

