/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class w<K, V> {
    private final LinkedHashMap<K, V> cb;
    private int size;
    private int cc;
    private int cd;
    private int ce;
    private int cf;
    private int cg;
    private int ch;

    public w(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.cc = n2;
        this.cb = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        w<K, V> w2 = this;
        synchronized (w2) {
            object = this.cb.get(key);
            if (object != null) {
                ++this.cg;
                return object;
            }
            ++this.ch;
        }
        w2 = this.create(key);
        if (w2 == null) {
            return null;
        }
        w w3 = this;
        synchronized (w3) {
            ++this.ce;
            object = this.cb.put(key, w2);
            if (object != null) {
                this.cb.put(key, object);
            } else {
                this.size += this.c(key, w2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, w2, object);
            return object;
        }
        this.trimToSize(this.cc);
        return (V)w2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        w w2 = this;
        synchronized (w2) {
            ++this.cd;
            this.size += this.c(key, value);
            v2 = this.cb.put(key, value);
            if (v2 != null) {
                this.size -= this.c(key, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, key, v2, value);
        }
        this.trimToSize(this.cc);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v2;
            K k2;
            w w2 = this;
            synchronized (w2) {
                if (this.size < 0 || this.cb.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.cb.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.cb.entrySet().iterator().next();
                k2 = entry.getKey();
                v2 = entry.getValue();
                this.cb.remove(k2);
                this.size -= this.c(k2, v2);
                ++this.cf;
            }
            this.entryRemoved(true, k2, v2, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int c(K k2, V v2) {
        int n2 = this.sizeOf(k2, v2);
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + k2 + "=" + v2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n2 = this.cg + this.ch;
        int n3 = n2 != 0 ? 100 * this.cg / n2 : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.cc, this.cg, this.ch, n3);
    }
}

